float    g_fTime;                   // App's time in seconds
//float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix
texture g_MeshTexture;              // Color texture for mesh

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV  : TEXCOORD0;  // vertex texture coords 
};

sampler2D input : register(s0);

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;

		float4x4 worldViewProjection = g_mWorldViewProjection;
		
		float2 sc;
		sincos(g_fTime, sc.x, sc.y);
		
		float4 rvPos = vPos;
		rvPos.x = vPos.x * sc.y + vPos.y * sc.x;
		rvPos.y = vPos.x * sc.x - vPos.y * sc.y;
		
		sincos(vPos.y, sc.x, sc.y);
		rvPos.x += sc.x*6.2;
		
		Output.Position = rvPos;
		Output.Position = mul(rvPos, worldViewProjection);
		Output.Diffuse = vColor; // (255, 255, 255, 255);
		Output.TextureUV = vTexCoord0;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------

	
PS_OUTPUT RenderScenePS( VS_OUTPUT In ) 
{ 
	float offset = 0.005;
	float scale = 5.8f;
	
    float4 Color; 
    float4 OrigColor;
    OrigColor = tex2D (input, In.TextureUV);
    Color = OrigColor;
    Color -= tex2D(input , In.TextureUV+offset)*scale; 
		Color += tex2D( input , In.TextureUV-offset)*scale; 
		Color.rgb = (Color.r+Color.g+Color.b);
		
    PS_OUTPUT Output;
    Output.RGBColor = Color * OrigColor;

    return Output;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Test
{
    pass P0
    {          
        VertexShader = compile vs_3_0 RenderSceneVS( );
        PixelShader  = compile ps_3_0 RenderScenePS( ); 
    }
}

