uniform sampler2D tex;
uniform sampler2D noiseTex;
uniform vec2 noisePos;

uniform float blurSize;
uniform float blurAmount;
 
void main(void)
{
	vec2 vTexCoord = gl_TexCoord[0].st;
	vec4 sum = vec4(0.0);

	float blur = blurAmount;
	sum = texture2D( tex, vec2( vTexCoord.x, vTexCoord.y ) ) * blur;
	float d = 0.0;
	float t = blur;
	for ( float i = 0.0; i <= blurAmount; i++ )
		{
		d += blurSize;
		blur -= 1.0;
		sum += texture2D( tex, vec2( vTexCoord.x, max( vTexCoord.y - d, 0.0 ) ) ) * float( blur );
		sum += texture2D( tex, vec2( vTexCoord.x, min( vTexCoord.y + d, 1.0 ) ) ) * float( blur );
		t += blur * 2.0;
		}
	sum /= t;
	
	sum *= texture2D( noiseTex, ( vTexCoord + noisePos ) * 10.0 );

	gl_FragColor = sum;
}
