#! /usr/bin/perl -w
 
# Perl OpenGL Demo 
# Author: Maria - Ganglion
# Date:  7.Mai 2009 - 18.Juli 2009

## Demo for solskogen 2009
## Group: Delirium Tremors
## Demoname: The broken monkey
## working group members: just me ... (Haha Daren!)



use OpenGL qw(:all);    # Use the OpenGL module
use strict;             # Use strict typechecking
use OpenGL::Image;		# um texturen einzubinden
use Image::Magick;		
use MPEG::MP3Play qw(:msg :state :mask);		# Um mp3s abzuspielen
use monkeySubs;			# File mit allen subroutinen zum Zeugszeichnen


# ASCII constant for the escape key
use constant ESCAPE => 27;

# Global variable for our window
my $window;

# Textures: 
my $titel;
my $end;
my $gangleon;

# Musik:
my $mp3 = new MPEG::MP3Play;
$mp3->open ("monkey-musik.mp3");

our $time=0;

	
# A general GL initialization function 
# Called right after our OpenGL window is created
# Sets all of the initial parameters
sub InitGL {              
	
    # Shift the width and height off of @_, in that order
    my ($width, $height) = @_;

    # Enables smooth color shading
    glShadeModel(GL_SMOOTH);      

    # Reset the projection matrix
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity;

    # Calculate the aspect ratio of the Window
    gluPerspective(45.0, $width/$height, 0.1, 100.0);
    
    # Reset the modelview matrix
    glMatrixMode(GL_MODELVIEW);

	# for alpha blanding
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
}


# The function called when our window is resized 
# This shouldn't happen, because we're fullscreen
sub ReSizeGLScene {

    # Shift width and height off of @_, in that order
    my ($width, $height) = @_;

    # Prevent divide by zero error if window is too small
    if ($height == 0) { $height = 1; }

    # Reset the current viewport and perspective transformation
    glViewport(0, 0, $width, $height);              

    # Re-initialize the window (same lines from InitGL)
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity;
    gluPerspective(45.0, $width/$height, 0.1, 100.0);
    glMatrixMode(GL_MODELVIEW);
}

sub lastTexture{

		$titel = glGenTextures_p( 1 );
		glBindTexture( GL_TEXTURE_2D, $titel);
		
		# last tekstur TITEL
{		my $img = new OpenGL::Image(source=>"monkey-titel.png");
		my($ifmt,$fmt,$type) = $img->Get('gl_internalformat','gl_format','gl_type');
		my($w,$h) = $img->Get('width','height');
		#glTexImage2D_c(GL_TEXTURE_2D, 0, $ifmt, $w, $h, 0, $fmt, $type, $img->Ptr()); 
		
		# The GLU library helps us build MipMaps for our texture.
		gluBuild2DMipmaps_c(GL_TEXTURE_2D, $ifmt, $w, $h, $fmt, $type, $img->Ptr());

		# sett filtrering
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST_MIPMAP_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
}

		$end = glGenTextures_p( 1 );
		glBindTexture( GL_TEXTURE_2D, $end);
		
		# last tekstur END
{		my $img = new OpenGL::Image(source=>"monkey-end.png");
		my($ifmt,$fmt,$type) = $img->Get('gl_internalformat','gl_format','gl_type');
		my($w,$h) = $img->Get('width','height');
		#glTexImage2D_c(GL_TEXTURE_2D, 0, $ifmt, $w, $h, 0, $fmt, $type, $img->Ptr()); 
		
		# The GLU library helps us build MipMaps for our texture.
		gluBuild2DMipmaps_c(GL_TEXTURE_2D, $ifmt, $w, $h, $fmt, $type, $img->Ptr());

		# sett filtrering
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST_MIPMAP_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
}



}
	
# The main drawing function.
sub DrawGLScene {
	
	my $msg;
	while ( $msg = $mp3->get_message ) {
		my $code = $msg->{code};
		if ( $code == &XA_MSG_NOTIFY_INPUT_POSITION ) {
			$time = $msg->{position_offset}*1.8;
		} elsif ( $code == &XA_MSG_NOTIFY_PLAYER_STATE ) {
			die if $msg->{state} == &XA_PLAYER_STATE_EOF;
		}
	
	}

 ## Abschließen und Fenster zu bei ##
 if($time>1075){
 	exit(0);
 	}


    glClearColor(1.0, 0.8, 0.7, 0.0); 					# background color  (letzte Zahl ist Transparenty)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 	# Clear the drawing area
        
    glLoadIdentity();  					# Reset the current matrix to the "identity"
   
## TITEL: ##
if ($time>20 && $time<200) {
	glPushMatrix();
	glLoadIdentity();
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, $titel);
	glEnable(GL_BLEND);
        glBegin(GL_POLYGON);
            glColor3d(1, 0.8, 0.7);
            glTexCoord2f(0,1);
			glVertex3d(-2.7,1.5,-4);
			glTexCoord2f(1,1);
            glVertex3d(-0.6,1.5,-4);
            glTexCoord2f(1,0);
            glVertex3d(-0.6,0.8,-4);
            glTexCoord2f(0,0);
            glVertex3d(-2.7,0.8,-4);
         glEnd();   
	glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glPopMatrix();
}     
     
        
## Sonne: ##
&monkeySubs::sonne($time);		# Subroutine zum Sonnenaufbau        
        
   

## Boot: ##
	glLoadIdentity();  					# Reset the current matrix to the "identity"
     
 	glTranslated(-1.5	,-0.2,-6);     	# beveger bort fra kamera
	glRotated(20, 0, -1, 0);  			# at baaten star paa skraa og beveger seg paa skraa
	glTranslated(sin($time/25.0)*3, cos($time/17.0)/2, 0);    # at den beveger seg og opp og ned
	glRotated(sin($time/7.0)*10, 0, 0, 1);
		
	glPushMatrix();			       		# husker matrix, som inneholder alle Translate og Rotrate
	glTranslated(0, (sin(0.8+$time/10.0)/4), 0);	# Boot - Wellenbewegung

    if ($time > 185 && $time <860){						# baaten kjem etterhvert & bort paa slutten
	    &monkeySubs::boot();							# Subroutine zum Boot aufbauen 
	 }   	

        glPopMatrix();      # den husked Matrix fra for ble kalled no, slik at Translate har ikke noe virkning mer
         
## Wellen:##
{		
		glLoadIdentity();  					# Reset the current matrix to the "identity"
       
		glTranslated(-1.5,-0.2,-6);     	# beveger bort fra kamera
		glRotated(20, 0, -1, 0);  		# at baaten star paa skraa og beveger seg paa skraa

        glBegin(GL_QUADS);
           glColor3d(0,0,0.6);
           
           for(my $i=-40; $i<40.0; $i=$i+0.1) 
              { 
               my $next_i=$i+0.1;
               glVertex3d($i,-20,0.01);
               glVertex3d($i,(sin($i+$time/10.0)/5)-0.5, 0.01);			# (x,y,z) Höhe sinus-wellenförmig
               glVertex3d($next_i,(sin($next_i+$time/10.0)/5)-0.5, 0.01);
               glVertex3d($next_i,-20,0.01);
               }
       glEnd();
}			# End Wellen
	


	
## Land: ##	
if ($time>430)
{	
	glLoadIdentity();  					# Reset the current matrix to the "identity"
   	glTranslated(6,-2.7,-6);   		  	# beveger bort fra kamera

	if ($time<720){
		glTranslated((-($time-360)/60)+3,(($time-360)/120)-2,0);   		  	# beveger seg sakte til sentrumet	
	}
	else {glTranslated((-(720-360)/60)+3,((720-360)/120)-2,0);}		#=680-360, $time-drüber
	
	glPushMatrix();
	glRotated(9, 0, -1, 70);  			# at øya er en sjev oval

	  glBegin(GL_TRIANGLES);   # oval
			for (my $i=0; $i<=70; $i++)
			{
				my $winkel = (6.28 * $i) / 70;
				my $winkel2 = (6.28 * ($i+1)) / 70;
				my $x = sin($winkel) * 7;
				my $y = cos($winkel) *3;
				my $x2 = sin($winkel2) *7;
				my $y2 = cos($winkel2) *3;
				glColor3d(0.2, 0.7, 0.2);    
				glVertex3d($x, $y, 0.0);
				glVertex3d($x2, $y2, 0.0);
				glVertex3d(0.0, 0.0, 0.0);
			}
		glEnd();
 
 
## Palmen: ##
 	glPopMatrix();
 	glTranslated(-2,0.5,0);
	
	&monkeySubs::palme(0,0);				# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.6,0.7);			# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.4,-1.3);		# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.3,0.4);			# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.4,1);			# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.8,0.4);			# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.6,-0.2);		# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.2,-1.2);		# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.4,-0.2);		# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.2,0.5);			# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.9,-0.2);		# subroutine zum Palmen zeichnen
	&monkeySubs::palme(0.6,0.7);			# subroutine zum Palmen zeichnen


## Arrow: ##
my $b;
if ($time>760 && $time < 780){
	if($time%5 < 1){
		$b = 0;
	}
	else{
		$b = 1;
	}
}
if($b == 1){
	glPushMatrix();
	glLoadIdentity();
		
	glTranslated(0,2.4,0);
	glRotated(210,0,0,100);
	glBegin(GL_TRIANGLES);
		glColor3d(0,0,0);
		glVertex3d(0.5,1,-4);
		glVertex3d(0.9,1,-4);
		glVertex3d(0.7,1.2,-4);
	glEnd();

	glBegin(GL_QUADS);
		glColor3d(0,0,0);
		glVertex3d(0.6,0.5,-4);
		glVertex3d(0.8,0.5,-4);
		glVertex3d(0.8,1,-4);
		glVertex3d(0.6,1,-4);
	glEnd();

	glPopMatrix();
	$b=0;
}	


## Kokosnuss: ##
	&monkeySubs::kokosnuss(-4,2);
	&monkeySubs::kokosnuss(-5.5,2.2);
	
	if ($time < 770) {
		&monkeySubs::kokosnuss(-5,2.2);
	}	
	elsif ($time <792){
		my $a = ($time-770)/10;
		&monkeySubs::kokosnuss(-5,2.2-$a);
	}


## Affe: ##
	if ($time<790){			#### skulle komme hoppende opp etterhvert !
         &monkeySubs::affe();			# Affensubroutine
	}
 elsif($time<880){
		&monkeySubs::affeStueckl();		# Affe kaputt subroutine
		}

}		# END if ($time>30){	

	
## End Bild: ##
if ($time>880) {
	glPushMatrix();
	glLoadIdentity();
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, $end);
	glEnable(GL_BLEND);
        glBegin(GL_POLYGON);
            glColor3d(1, 0.8, 0.7);
            glTexCoord2f(1,1);
			glVertex3d(1,0.7,-2);	# re ob
			glTexCoord2f(1,0);
            glVertex3d(1,-1,-2);	# re un
            glTexCoord2f(0,0);
            glVertex3d(-2,-1,-2);	# li un
            glTexCoord2f(0,1);
            glVertex3d(-2,0.7,-2); # li ob
         glEnd();   
	glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glPopMatrix();
}     


    # Since this is double buffered, swap the buffers.
    # This will display what just got drawn.
    glutSwapBuffers;
    
}				# END DrawGLScene

 ####################################
 ####################################

# The function called whenever a key is pressed. 
sub keyPressed {

    # Shift the unsigned char key, and the x,y placement off @_, in
    # that order.
    my ($key, $x, $y) = @_;
  
    # If escape is pressed, kill everything.
    if ($key == ESCAPE) 
    { 
        # Shut down our window 
        glutDestroyWindow($window); 
        
        # Exit the program...normal termination.
        exit(0);
                           
    }
}

# --- Main program ---

# Initialize GLUT state
glutInit;  

# Select type of Display mode:   
# Double buffer 
# RGB color (Also try GLUT_RGBA)
# Alpha components removed (try GLUT_ALPHA) 
# Depth buffer */  
glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);  


# The window starts at the upper left corner of the screen
glutInitWindowPosition(0, 0);  

# Open the window  
$window = glutCreateWindow("The broken Monkey");		# Titel  

# Register the function to do all our OpenGL drawing.
glutDisplayFunc(\&DrawGLScene);  

# Go fullscreen.  This is as soon as possible. 
glutFullScreen;

# Even if there are no events, redraw our gl scene.
glutIdleFunc(\&DrawGLScene);

# Register the function called when our window is resized. 
glutReshapeFunc(\&ReSizeGLScene);

# Register the function called when the keyboard is pressed.
glutKeyboardFunc(\&keyPressed);

# Initialize our window.
InitGL(640, 480);		# Changes a lot!!! because of Depth which is in work now... (uten er der bare det som tegnes sist er frammest)

# Textur lasting:  
lastTexture();			# Texture wird geladen
 
#Musik
	$mp3->set_notification_mask(&XA_NOTIFY_MASK_INPUT_POSITION, &XA_MSG_NOTIFY_PLAYER_STATE);
	$mp3->set_input_position_range(60*10);
      $mp3->play;  
  
# Start Event Processing Engine
glutMainLoop;  

return 1;


