float4x4 transf;

texture tex;
sampler texS = 
sampler_state
{	
	Texture = <tex>;
	AddressU = WRAP;
	AddressV = WRAP;
	MIPFILTER = LINEAR;
	MAGFILTER = LINEAR;
	MINFILTER = LINEAR;
};

texture tex1;
sampler texS1 = 
sampler_state
{	
	Texture = <tex1>;
	AddressU = WRAP;
	AddressV = WRAP;
	MIPFILTER = LINEAR;
	MAGFILTER = LINEAR;
	MINFILTER = LINEAR;
};


struct IN_Vertex {
    float4 pos		: POSITION;
    float2 tx	 	: TEXCOORD0; 
};

struct OUT_Vertex {
    float4 pos : POSITION;
    float2 tx	: TEXCOORD0;
};

struct PS_In {
    float2 tx: TEXCOORD0;
};

struct PS_Out {
	float4 pixel	: COLOR0;
};

OUT_Vertex VS_TexRend ( IN_Vertex IN ) {
	OUT_Vertex OUT;
	OUT.pos = mul( IN.pos, transf );
	OUT.tx = IN.tx;
	return OUT;
}

PS_Out PS_TexRend ( PS_In IN ) 
{
	PS_Out OUT;
	OUT.pixel = tex2D( texS, IN.tx );
	return OUT;
}

PS_Out PS_Text ( PS_In IN ) 
{
	PS_Out OUT;
	OUT.pixel = tex2D( texS, IN.tx ) * 1.1f;
	return OUT;
}

float blendFactor;

OUT_Vertex VS_TexBlend ( IN_Vertex IN ) {
	OUT_Vertex OUT;
	OUT.pos = mul( IN.pos, transf );
	OUT.tx = IN.tx;
	return OUT;
}

PS_Out PS_TexBlend ( PS_In IN ) 
{
	PS_Out OUT;
	OUT.pixel = tex2D( texS1, IN.tx ) * blendFactor + tex2D( texS, IN.tx ) * (1.0f - blendFactor);
	//OUT.pixel = float4(1,1,1,1) * blendFactor;
	return OUT;
}


technique TexRend
{
    pass p0
    {
		AlphaBlendEnable = True;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_2_0 VS_TexRend ();
		PixelShader = compile ps_2_0 PS_TexRend ();
    }
}


technique text
{
    pass p0
    {
		AlphaBlendEnable = True;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_2_0 VS_TexRend ();
		PixelShader = compile ps_2_0 PS_Text ();
    }
}

technique TexBlend
{
    pass p0
    {
		AlphaBlendEnable = False;
		VertexShader = compile vs_2_0 VS_TexBlend ();
		PixelShader = compile ps_2_0 PS_TexBlend ();
    }
}

float ditherF;
float thre;

float nOfsX, nOfsY;

float4 closest ( float4 inp ) {
	if ( inp.r + inp.g + inp.g < thre*1.f ) {
		return float4( .6f,0,0, inp.a );	
	} else 
	if ( inp.r + inp.g + inp.g > thre*3.7f ) {
		return float4( .6f,0,0, inp.a );	
	} else 
	if ( inp.r + inp.g + inp.g > thre*3 ) {
		return float4( 1,1,1, inp.a );	
	} else {
		return float4( 0,0,0, inp.a );	
	}
}

PS_Out PS_Dither ( PS_In IN ) 
{
	PS_Out OUT;
	OUT.pixel = closest ( tex2D(texS1, IN.tx + float2( nOfsX, nOfsY) ) * ditherF + (1.f - ditherF) * tex2D( texS, IN.tx ) );
	return OUT;
}

technique Dither
{
    pass p0
    {
		VertexShader = compile vs_2_0 VS_TexBlend ();
		PixelShader = compile ps_2_0 PS_Dither ();
    }
}


