;2009/04/26 baah of Arm's Tech
  move.l    #$0,-(sp)       ;Switch to supervisor
  move.w    #$20,-(sp)
  trap      #$1
  addq.l    #$6,sp
  pea       Text            ;Print message
  move.w    #$9,-(sp)
  trap      #$1
  addq.l    #$6,sp
WaitAKey:  
  move.w    #$7,-(sp)       ;Wait a key
  trap      #$1
  addq.l    #$2,sp
  cmp.w     #" ",d0         ;Space?
  beq.s     PutBoot
Exit:
  clr.w    -(sp)            ;Else exit.
  trap    #$1


PutBoot:
  move.w    #1,-(sp)        ;Read sector
  move.w    #0,-(sp)        ;Side 0
  move.w    #0,-(sp)        ;Track 0
  move.w    #1,-(sp)        ;Sector 1
  move.w    #0,-(sp)        ;Disk A
  clr.l     -(sp)
  move.l    #OldBoot,-(sp)  ;Buffer
  move.w    #$8,-(sp)
  trap      #$e             ;Floppy read
  add.l     #20,sp
;Copy NewBoot and branch instruction  
  move.l    #NewBoot,a0
  move.l    #OldBoot+$3a,a1
  move.w    #511,d0         ;We'll copy too much
Copy:
  move.b    (a0)+,(a1)+
  dbra      d0,Copy
  move.w    #$6038,OldBoot  ;Put branch instruction
;Set checksum so that the sum of words is $1234
Checksum:
  move.l    #OldBoot,a0
  moveq.l   #$0,d0
  move.l    #254,d1         ;Sum up 255 words
AddWord:
  add.w     (a0)+,d0
  dbra      d1,AddWord
  move.w    #$1234,d1
  sub.w     d0,d1           ;d1=$1234-sum
  move.w    d1,(a0)         
;Save new boot
  move.w    #1,-(sp)        ;Write sector
  move.w    #0,-(sp)        ;Side 0
  move.w    #0,-(sp)        ;Track 0
  move.w    #1,-(sp)        ;Sector 1
  move.w    #0,-(sp)        ;Disk A
  clr.l     -(sp)
  move.l    #OldBoot,-(sp)  ;Buffer
  move.w    #$9,-(sp)
  trap      #$e             ;Floppy write
  add.l     #20,sp
  bra       WaitAKey        ;Another boot to install?

Text:
  dc.b    'Bootsector by baah of Arm''s Tech.',$d,$a
  dc.b    '',$d,$a
  dc.b    'Press <space> to install bootsector.',$d,$a
  dc.b    '',$d,$a
  dc.b    '',$d,$a
  dc.b    '',$d,$a,$0

 even

;*********** LouZy77 depacker and packed file ************
Min EQU 3

NewBoot:
  lea       PackedData(pc),a0
  lea       Where2Depack(pc),a1
;a0=@PackedData
;a1=@Where2Depack
Depacker
  moveq.l   #0,d0
  move.b    (a0)+,d0    ;d0=ControlByte
  beq.s     DpkEnd
  bmi.s     DpkMatch
DpkNoMatch
  move.l    a0,a2       ;a2=@CopyFrom=@PackedData
  add.l     d0,a0       ;a0+=NbNoMatch
  subq.l    #1,d0
  bra.s     DpkCopyOne
DpkMatch
  moveq.l   #0,d1
  move.b    (a0)+,d1    ;d1=Offset-1
  addq.l    #1,d1       ;d1=Offset
  move.l    a1,a2       ;a2=@Where2Depack
  sub.l     d1,a2       ;a2=@CopyFrom=@Where2Depack-Offset
  sub.b     #129-Min,d0 ;d0=NbMatch=Control-128+Min-1
DpkCopyOne
  move.b    (a2)+,(a1)+
  dbra      d0,DpkCopyOne
  bra.s     Depacker
DpkEnd
  bra Where2Depack

PackedData ;ABCDABDABCD
  ; dc.b $06,$41,$42,$43,$44,$41,$42,$80,$02,$02,$43,$44,$00
  incbin 'dla.pk'
  even
  
Where2Depack
 REPT 3
  dc.b 'baAhBaAhbaaHBAAHbaahbAaHBaahbAAhbAAHBaAHBAaHbaaHbAaHbaahBAAH'
  dc.b 'BaahbaAhBAahbaAHbaAHBAaHBAAhBaahBaAhBaahbAAHBAahbaaHbAAhbaaH'
  dc.b 'BaaHBAAhBAAHbAahbAaHbAahbaAHBAAhbaahBaAHbaahBAahBAAHbAAHBaAh'
 ENDR

;*************************************************************************

  Section BSS

OldBoot:        ; Un bootsecteur=512 octets.
  ds.w    256
  ds.w    256    ; Un petit extra.
