string Description = "This shader produces a colored glass effect with refraction, distorting the view through the glass and requires a higher pixel shader version";
string Thumbnail = "Colored Glass 2.png";

float4x4 WorldViewProj : WorldViewProjection;
float4x4 World : World;
float4x4 WorldView : WorldView;
float4 eyePos : CameraPosition;

float Opacity
<
	string SasUIControl = "slider";
	float SasUIMax = 1.0;
	float SasUIMin = 0.0;
	float SasUIStep = 0.01;
> = 0.000000;

float4 diffuse : COLOR
<
	string SasUIControl = "Color Picker";
> = { 0.000000, 0.000000, 0.501961, 0.000000 };

texture Background : DIFFUSE
<
	string ResourceName = "";
	string Type = "2D";
	string Dynamic = "Background";
>;

sampler texture1 = sampler_state
{
	Texture = <Background>;
	MinFilter = Anisotropic;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Clamp;
	AddressV = Clamp;
};

texture ReflectionTex
<
	string ResourceName = "";
	string ResourceType = "Cube";
	string Dynamic = "Reflection"; 
>;

samplerCUBE Reflection_smp = sampler_state 
{
	Texture = <ReflectionTex>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Clamp;
	AddressV = Clamp;
};

struct app_in
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
};

struct vs_out
{
	float4 pos : POSITION;
	float4 projUV : TEXCOORD0;
	float3 normal : TEXCOORD1;
	float3 vNormal : TEXCOORD2;
	float3 wPos : TEXCOORD3;
};

vs_out DefaultVertexShader( app_in IN )
{
	vs_out OUT;
	
	OUT.pos = mul( IN.pos, WorldViewProj );
	
	float4 wPos = mul( IN.pos, World );
	float3 wNormal = mul( IN.normal, (float3x3)World );
	float3 vNormal = mul( IN.normal, (float3x3)WorldViewProj );
	
	OUT.wPos = wPos.xyz;
	OUT.normal = normalize( wNormal );
	OUT.vNormal = normalize( vNormal );
	
	OUT.projUV = float4( OUT.pos.x*0.5 + 0.5*OUT.pos.w, 0.5*OUT.pos.w - OUT.pos.y*0.5, OUT.pos.w, OUT.pos.w );
	
	return OUT;
}

float4 DefaultPixelShader( vs_out IN ) : COLOR
{
	float2 uv = IN.projUV.xy / IN.projUV.w;
	
	float3 viewDir = normalize(eyePos - IN.wPos);
	
	float3 Dir = reflect( -viewDir, IN.normal );
	float4 refl = texCUBE( Reflection_smp, Dir );
	
	refl = refl*refl*3;
	
	float angle = 1 - saturate( dot( IN.normal, viewDir ) );
	uv += IN.vNormal.xy * angle * float2(-0.2,0.2);
	
	float4 bkgnd = tex2D( texture1, uv );	
	bkgnd = lerp( bkgnd, float4(1,1,1,1), Opacity );
	
	float angle2 = 1 - angle*angle;
	float4 color = lerp( refl, bkgnd*diffuse, angle2 );
	
	return float4(color.xyz,1);
}

technique MyShader
{
	pass p0
	{
		VertexShader = compile vs_1_1 DefaultVertexShader( );
		PixelShader = compile ps_2_0 DefaultPixelShader( );
	}
}
