/*
 * Decompiled with CFR 0.152.
 */
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import krister.Ess.AudioChannel;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;
import krister.Ess.FFT;
import processing.core.PApplet;
import processing.core.PImage;
import vitamin.VGL;
import vitamin.VTexture2D;
import vitamin.VTimer;
import vitamin.math.Color4;
import vitamin.math.Vector2;

public class WinterBreathe
extends PApplet {
    boolean renderToVideo = false;
    boolean doSound = true;
    boolean bol0 = false;
    boolean bol1 = false;
    boolean bol2 = false;
    boolean bol3 = false;
    boolean bol4 = false;
    boolean bol5 = false;
    boolean bol6 = false;
    int COLORTHRESHOLD = 100;
    int MAXPOINTS = 5000;
    int numOfHolders = 7;
    ArrayList _holders;
    PointHolder _currHolder;
    int _currHolderIdx = 0;
    float xbooster = 1.0f;
    FFTHelper ffthelper;
    int spectrumLength = 2048;
    int bandsteps;
    float maxdist;
    float damperval;
    float frequencyScale = 3.0f;
    float startTime = 0.0f;
    VGL vgl;
    VTimer timer;
    VTexture2D _tex;
    int numParticles = 15000;
    ParticleManager pman;
    float _mouseX;
    float _mouseY;
    int numOfColors;
    Color4[] colors;
    AudioChannel chn;
    FFT fft;
    int frameNumber = 0;
    int framesPerSecond = 25;
    float level;
    float[] fftbuffer;
    float lastTime;
    float currentTime;

    public void setup() {
        this.size(960, 89, "processing.opengl.PGraphicsOpenGL");
        this.hint(2);
        this.smooth();
        this.vgl = new VGL((PApplet)this);
        this._tex = new VTexture2D(this.vgl.gl(), this.dataPath("flare3.png"));
        this.numOfColors = 5;
        this.colors = new Color4[this.numOfColors];
        this.colors[0] = new Color4(9, 38, 112);
        this.colors[1] = new Color4(28, 178, 184);
        this.colors[2] = new Color4(146, 209, 224);
        this.colors[3] = new Color4(114, 139, 166);
        this.colors[4] = new Color4(55, 230, 206);
        this._holders = new ArrayList();
        int n = 0;
        while (n < this.numOfHolders) {
            PointHolder pointHolder = new PointHolder("test" + (n + 1) + ".jpg");
            pointHolder.process();
            this._holders.add(pointHolder);
            ++n;
        }
        this._currHolderIdx = 0;
        this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
        this._mouseY = 0.0f;
        this._mouseX = 0.0f;
        this.pman = new ParticleManager(this.numParticles);
        this.background(0);
        this.strokeWeight(1.0f);
        this.rectMode(3);
        this.ellipseMode(3);
        this.randomSeed(12345L);
        if (this.doSound) {
            this.init_sound(2048, this.dataPath("winter_breathe.mp3"));
            this.chn.volume(1.0f);
            if (!this.renderToVideo) {
                this.chn.play();
            }
        }
        if (this.renderToVideo) {
            this.timer = new VTimer(VTimer.OFFLINE, 25);
            this.timer.start();
        } else {
            this.timer = new VTimer();
            this.timer.start();
            this.startTime = this.timer.getCurrTime();
        }
    }

    public void draw() {
        float f = this.timer.getCurrTime();
        this.timer.update();
        if (this.doSound) {
            this.analyze(this.frequencyScale * 15.0f);
        }
        this.vgl.begin();
        this.vgl.ortho((float)this.width, (float)this.height);
        this.vgl.setDepthWrite(false);
        this.vgl.setAlphaBlend();
        this.vgl.enableTexture(false);
        if (this.doSound) {
            this.vgl.fill(0.0f, 1.0f - 1.0f * this.ffthelper.bandmax[100]);
        } else {
            this.vgl.fill(0.0f, 1.0f);
        }
        this.vgl.pushMatrix();
        this.vgl.translate((float)this.width * 0.5f, (float)this.height * 0.5f);
        this.vgl.rect((float)this.width, (float)this.height);
        this.vgl.popMatrix();
        this.vgl.setAdditiveBlend();
        this.pman.manage(this.vgl.gl(), f);
        this.vgl.end();
        this._mouseX = this.ffthelper.band[20] * this.random((float)this.width * this.xbooster * 0.1f) * 100.0f;
        this._mouseY = this.ffthelper.band[40] * this.random(this.height) * 100.0f;
        if (this.renderToVideo) {
            this.store("winterbreathe", "SEQ", "png");
            this.advance();
        }
        if (f > 30.0f && !this.bol4) {
            this.bol4 = true;
            this._currHolderIdx = 4;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            if (this.renderToVideo) {
                int n = 0;
                while (n < this.pman.numP) {
                    if (this.pman.particles[n]._origin == null) {
                        this.pman.particles[n]._origin = this.findClosestPoint(new Vector2(this.pman.particles[n]._x, this.pman.particles[n]._y));
                    }
                    if (this.pman.particles[n]._origin != null) {
                        this.pman.particles[n].pointPicked = true;
                    }
                    ++n;
                }
            } else {
                ChangeParticles changeParticles = new ChangeParticles(this.pman);
                new Thread(changeParticles).start();
            }
        }
        if (f > 48.0f && !this.bol0) {
            this.bol0 = true;
            this._currHolderIdx = 3;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            if (this.renderToVideo) {
                int n = 0;
                while (n < this.pman.numP) {
                    if (this.pman.particles[n]._origin == null) {
                        this.pman.particles[n]._origin = this.findClosestPoint(new Vector2(this.pman.particles[n]._x, this.pman.particles[n]._y));
                    }
                    if (this.pman.particles[n]._origin != null) {
                        this.pman.particles[n].pointPicked = true;
                    }
                    ++n;
                }
            } else {
                ChangeParticles changeParticles = new ChangeParticles(this.pman);
                new Thread(changeParticles).start();
            }
        }
        if (f > 79.0f && !this.bol2) {
            this.bol2 = true;
            this._currHolderIdx = 2;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            if (this.renderToVideo) {
                int n = 0;
                while (n < this.pman.numP) {
                    if (this.pman.particles[n]._origin == null) {
                        this.pman.particles[n]._origin = this.findClosestPoint(new Vector2(this.pman.particles[n]._x, this.pman.particles[n]._y));
                    }
                    if (this.pman.particles[n]._origin != null) {
                        this.pman.particles[n].pointPicked = true;
                    }
                    ++n;
                }
            } else {
                ChangeParticles changeParticles = new ChangeParticles(this.pman);
                new Thread(changeParticles).start();
            }
        }
        if (f > 102.0f && !this.bol3) {
            this.bol3 = true;
            this.xbooster = 3.0f;
            this._currHolderIdx = 3;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            ChangeParticles changeParticles = new ChangeParticles(this.pman);
            new Thread(changeParticles).start();
        }
        if (f > 154.0f && !this.bol5) {
            this.bol5 = true;
            this._currHolderIdx = 5;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            if (this.renderToVideo) {
                int n = 0;
                while (n < this.pman.numP) {
                    if (this.pman.particles[n]._origin == null) {
                        this.pman.particles[n]._origin = this.findClosestPoint(new Vector2(this.pman.particles[n]._x, this.pman.particles[n]._y));
                    }
                    if (this.pman.particles[n]._origin != null) {
                        this.pman.particles[n].pointPicked = true;
                    }
                    ++n;
                }
            } else {
                ChangeParticles changeParticles = new ChangeParticles(this.pman);
                new Thread(changeParticles).start();
            }
        }
        if (f > 160.0f && !this.bol6) {
            this.bol6 = true;
            this._currHolderIdx = 6;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            if (this.renderToVideo) {
                int n = 0;
                while (n < this.pman.numP) {
                    if (this.pman.particles[n]._origin == null) {
                        this.pman.particles[n]._origin = this.findClosestPoint(new Vector2(this.pman.particles[n]._x, this.pman.particles[n]._y));
                    }
                    if (this.pman.particles[n]._origin != null) {
                        this.pman.particles[n].pointPicked = true;
                    }
                    ++n;
                }
            } else {
                ChangeParticles changeParticles = new ChangeParticles(this.pman);
                new Thread(changeParticles).start();
            }
        }
        if (f >= 166.0f) {
            this.vgl.ortho();
            this.vgl.enableTexture(false);
            this.vgl.setAlphaBlend();
            this.vgl.fill(0.0f, (f - 166.0f) * 0.2f);
            this.vgl.rect(1.0f, 1.0f);
        }
        if (f >= 171.0f) {
            System.exit(0);
        }
    }

    public Vector2 findClosestPoint(Vector2 vector2) {
        PointHolder pointHolder = (PointHolder)this._holders.get(this._currHolderIdx);
        float f = 9999.0f;
        int n = 0;
        int n2 = 0;
        while (n2 < pointHolder._points.size()) {
            Vector2 vector22 = (Vector2)pointHolder._points.get(n2);
            float f2 = Vector2.distance((Vector2)vector22, (Vector2)vector2);
            if (f2 < f) {
                n = n2;
                f = f2;
            }
            if (f < 10.0f) {
                return (Vector2)pointHolder._points.get(n2);
            }
            ++n2;
        }
        if (f < 10.0f) {
            return (Vector2)pointHolder._points.get(n);
        }
        return null;
    }

    public void keyPressed() {
        int n = this.key - 49;
        if (this.keyCode != 27) {
            if (n >= this.numOfHolders) {
                return;
            }
            this._currHolderIdx = n;
            this._currHolder = (PointHolder)this._holders.get(this._currHolderIdx);
            ChangeParticles changeParticles = new ChangeParticles(this.pman);
            new Thread(changeParticles).start();
            WinterBreathe.println((String)("image '" + (this._currHolderIdx + 1) + "' at time: " + this.timer.getCurrTime()));
        }
    }

    public void keyReleased() {
    }

    public void init_sound(int n, String string) {
        this.lastTime = 0.0f;
        this.currentTime = 0.0f;
        Ess.start((PApplet)this);
        Ess.masterVolume((float)1.0f);
        WinterBreathe.println((String)("loading " + string));
        this.chn = new AudioChannel(string);
        this.fft = new FFT(n * 2);
        this.fft.limits();
        this.ffthelper = new FFTHelper(n, 256, false);
        this.ffthelper.setMaxLimits(200.0f, 2000.0f);
        this.damperval = 0.62f;
        this.ffthelper.setDamper(this.damperval);
        this.fftbuffer = new float[n];
    }

    public void play_sound() {
        this.chn.volume(1.0f);
        this.chn.play();
    }

    public void analyze(float f) {
        if (this.renderToVideo) {
            int n = (int)((float)this.frameNumber * this.chn.sampleRate / (float)this.framesPerSecond);
            if (n >= this.chn.size) {
                System.exit(0);
            }
            try {
                this.fft.getSpectrum(this.chn.samples, n);
                int n2 = 0;
                while (n2 < this.fft.spectrum.length) {
                    this.fftbuffer[n2] = this.fft.spectrum[n2] * f;
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                WinterBreathe.println((String)("exploded ess: " + arrayIndexOutOfBoundsException));
            }
        } else {
            try {
                this.fft.getSpectrum((AudioOutput)this.chn);
                int n = 0;
                while (n < this.fft.spectrum.length) {
                    this.fftbuffer[n] = this.fft.spectrum[n] * f;
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                WinterBreathe.println((String)("exploded ess: " + arrayIndexOutOfBoundsException));
            }
        }
        this.ffthelper.update(this.fftbuffer);
    }

    public void store(String string, String string2, String string3) {
        this.saveFrame(String.valueOf(string2) + "/" + string + "_" + WinterBreathe.nf((int)this.frameNumber, (int)7) + "." + string3);
    }

    public void advance() {
        if (this.frameNumber % this.framesPerSecond == 0) {
            this.lastTime = this.currentTime;
            this.currentTime = (float)this.millis() * 0.001f - this.startTime;
            WinterBreathe.println((String)("Frame: " + this.frameNumber + " | time: " + this.currentTime / 60.0f / 60.0f + "h" + " | average time per frame: " + (this.currentTime - this.lastTime) / (float)this.framesPerSecond + " secs"));
        }
        ++this.frameNumber;
    }

    public void volume(float f) {
        Ess.masterVolume((float)f);
    }

    public void stop_sound() {
        this.chn.stop();
        Ess.stop();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ECE9D8", "WinterBreathe"});
    }

    public class ChangeParticles
    implements Runnable {
        ParticleManager _pm;

        public ChangeParticles(ParticleManager particleManager) {
            this._pm = particleManager;
        }

        public void run() {
            int n = 0;
            while (n < this._pm.numP) {
                if (this._pm.particles[n]._origin == null) {
                    this._pm.particles[n]._origin = WinterBreathe.this.findClosestPoint(new Vector2(this._pm.particles[n]._x, this._pm.particles[n]._y));
                }
                if (this._pm.particles[n]._origin != null) {
                    this._pm.particles[n].pointPicked = true;
                }
                ++n;
            }
        }
    }

    public class FFTHelper {
        public int num;
        public int numbands;
        public float[] spectrum;
        public float[] ttv;
        public double[] v;
        private double[] tv;
        double dampUp;
        double dampDown;
        double mult;
        boolean doDampen = false;
        boolean doDampenAsymm = false;
        boolean doAverage = false;
        boolean isFirstTime = true;
        boolean doNorm = false;
        public double maxinternal;
        public float max;
        public float maxMinimum;
        public float maxMaximum;
        double maxD;
        int maxCnt;
        double[] bandv;
        public float[] band;
        public float[] bandmax;
        public int bandsteps;

        public FFTHelper(int n, int n2, boolean bl) {
            this.num = n;
            this.numbands = n2;
            this.spectrum = new float[this.num];
            this.v = new double[this.num];
            this.tv = new double[this.num];
            this.ttv = new float[this.num];
            this.doAverage = bl;
            this.doNorm = true;
            this.mult = 1.0;
            this.maxMinimum = 200.0f;
            this.maxMaximum = 2000.0f;
            this.maxinternal = this.maxMinimum;
            this.maxCnt = 0;
            this.bandsteps = 256 / this.numbands;
            this.band = new float[this.numbands];
            this.bandv = new double[this.numbands];
            this.bandmax = new float[this.numbands];
        }

        public void setMaxLimits(float f, float f2) {
            this.maxMinimum = f;
            this.maxMaximum = f2;
        }

        public void setDamper(double d, double d2) {
            this.dampUp = d;
            this.dampDown = d2;
            this.doDampen = this.dampUp != -1.0;
            this.doDampenAsymm = true;
        }

        public void setDamper(double d) {
            this.setDamper(d, d);
            this.doDampenAsymm = false;
        }

        public float dampenVal(double d, double d2) {
            d = this.doDampenAsymm ? (d > d2 ? d2 * this.dampDown + d * (1.0 - this.dampDown) : d2 * this.dampUp + d * (1.0 - this.dampUp)) : d2 * this.dampUp + d * (1.0 - this.dampUp);
            return (float)d;
        }

        public void update(float[] fArray) {
            int n;
            int n2;
            if (this.isFirstTime) {
                this.isFirstTime = false;
            }
            if (this.doAverage) {
                this.tv[0] = (fArray[0] + fArray[1]) * 0.5f;
                this.tv[this.num - 1] = (fArray[this.num - 1] + fArray[this.num - 2]) * 0.5f;
                n2 = 1;
                while (n2 < this.num - 1) {
                    this.tv[n2] = (fArray[n2 - 1] + fArray[n2] + fArray[n2 + 1]) * 0.333f;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.tv[n2] = fArray[n2];
                    ++n2;
                }
            }
            if (this.doDampen && !this.isFirstTime) {
                if (this.doDampenAsymm) {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.v[n2] > this.tv[n2] ? this.tv[n2] * this.dampDown + this.v[n2] * (1.0 - this.dampDown) : this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        if (this.v[n2] > (double)this.maxMaximum) {
                            this.v[n2] = this.maxMaximum;
                        }
                        ++n2;
                    }
                }
            } else {
                System.arraycopy(this.tv, 0, this.v, 0, this.num);
            }
            if (this.doNorm) {
                double d = 0.0;
                double d2 = 0.0;
                if (this.maxCnt > 0) {
                    this.maxinternal += this.maxD;
                    --this.maxCnt;
                }
                n = 0;
                while (n < this.num) {
                    if (this.v[n] > this.maxinternal) {
                        this.maxinternal = this.v[n];
                        this.maxD = (this.v[n] - this.maxinternal) / 4.0;
                        this.maxCnt = 4;
                        this.maxinternal += this.maxD;
                        --this.maxCnt;
                    }
                    d2 += this.v[n];
                    if (this.v[n] > d) {
                        d = this.v[n];
                    }
                    ++n;
                }
                if (d > (double)this.maxMaximum) {
                    d = this.maxMaximum;
                }
                if (this.maxinternal > (double)this.maxMinimum && this.maxCnt == 0) {
                    this.maxinternal = d * (double)0.005f + this.maxinternal * (double)0.995f;
                } else if (this.maxinternal > (double)this.maxMaximum) {
                    this.maxinternal = this.maxMaximum;
                }
                d2 /= (double)this.num;
                n = 0;
                while (n < this.num) {
                    this.spectrum[n] = (float)(this.v[n] / this.maxinternal);
                    if (this.spectrum[n] > 1.0f) {
                        this.spectrum[n] = 1.0f;
                    }
                    ++n;
                }
                this.max = (float)this.maxinternal;
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.spectrum[n2] = (float)this.v[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.numbands) {
                double d = this.bandv[n4];
                this.bandv[n4] = 0.0;
                n = 0;
                while (n < this.bandsteps) {
                    int n5 = n4;
                    this.bandv[n5] = this.bandv[n5] + (double)this.spectrum[n3++];
                    ++n;
                }
                int n6 = n4;
                this.bandv[n6] = this.bandv[n6] / (double)this.bandsteps;
                this.bandv[n4] = this.dampenVal(d, this.bandv[n4]);
                if ((double)this.bandmax[n4] < this.bandv[n4]) {
                    this.bandmax[n4] = (float)this.bandv[n4];
                } else {
                    int n7 = n4;
                    this.bandmax[n7] = this.bandmax[n7] * 0.995f;
                }
                this.band[n4] = (float)this.bandv[n4];
                ++n4;
            }
        }

        public void update(float[] fArray, int n, int n2) {
            System.arraycopy(fArray, n, this.ttv, 0, n2);
            this.update(this.ttv);
        }

        public void updateBands(float[] fArray, int n) {
            int n2 = fArray.length / n;
            float f = 0.0f;
            int n3 = 0;
            while (n3 < n2) {
                f = 0.0f;
                int n4 = 0;
                while (n4 < n2) {
                    f += fArray[n3 * n2 + n4];
                    ++n4;
                }
                this.ttv[n3] = f / (float)n2;
                ++n3;
            }
            this.update(this.ttv);
        }

        public double checkBandMax(int n) {
            return this.bandmax[n / this.bandsteps];
        }
    }

    class ParticleManager {
        FloatBuffer pointBuffer;
        FloatBuffer colorBuffer;
        FloatBuffer lineBuffer;
        IntBuffer indexBuffer;
        p[] particles;
        int numP;

        ParticleManager(int n) {
            int n2;
            this.numP = n;
            int n3 = this.numP * 2;
            this.indexBuffer = ByteBuffer.allocateDirect(4 * n3).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.indexBuffer.limit(n3);
            this.indexBuffer.rewind();
            this.particles = new p[this.numP];
            int n4 = 0;
            while (n4 < this.numP) {
                this.particles[n4] = new p((float)n4 / (float)this.numP, WinterBreathe.this.random(WinterBreathe.this.width), WinterBreathe.this.random(WinterBreathe.this.height), 0.0f);
                if (n4 > 0) {
                    this.indexBuffer.put(n4 * 2, n4);
                    n2 = PApplet.parseInt((float)WinterBreathe.this.random(n4));
                    this.indexBuffer.put(n4 * 2 + 1, n2);
                }
                ++n4;
            }
            n4 = this.numP * 3;
            this.pointBuffer = ByteBuffer.allocateDirect(4 * n4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.pointBuffer.limit(n4);
            this.pointBuffer.rewind();
            n4 = this.numP * 4;
            this.colorBuffer = ByteBuffer.allocateDirect(4 * n4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.colorBuffer.limit(n4);
            this.colorBuffer.rewind();
            n2 = 0;
            while (n2 < n4) {
                this.colorBuffer.put(n2, 1.0f);
                ++n2;
            }
            this.colorBuffer.rewind();
            n4 = this.numP * 4;
            this.lineBuffer = ByteBuffer.allocateDirect(4 * n4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.lineBuffer.limit(n4);
            this.lineBuffer.rewind();
        }

        public void manage(GL gL, float f) {
            int n = 0;
            while (n < this.numP) {
                if (WinterBreathe.this.ffthelper.band[n % 255] >= 0.02f) {
                    this.particles[n]._speed = WinterBreathe.this.ffthelper.band[n % 255] * 120.0f;
                }
                this.particles[n].a = WinterBreathe.this.ffthelper.band[n % 255] * 100.0f;
                float f2 = WinterBreathe.this.ffthelper.bandmax[n % 255] * 100.0f;
                this.particles[n].update(f + f2);
                this.pointBuffer.rewind();
                this.particles[n].writePositionToBuffer(this.pointBuffer, n * 3);
                this.colorBuffer.rewind();
                this.particles[n].writeColorToBuffer(this.colorBuffer, n * 4);
                this.lineBuffer.rewind();
                this.particles[n].writeDirectionToBuffer(this.lineBuffer, n * 4);
                ++n;
            }
            gL.glLineWidth(1.0f);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(2, 5126, 0, (Buffer)this.lineBuffer);
            if (WinterBreathe.this.timer.getCurrTime() < 1.0f) {
                gL.glColor4f(1.0f, 1.0f, 1.0f, 0.4f * WinterBreathe.this.timer.getCurrTime() * 0.5f);
            } else {
                gL.glColor4f(1.0f, 1.0f, 1.0f, 0.4f * WinterBreathe.this.ffthelper.bandmax[90] * 10.0f);
            }
            gL.glDrawArrays(1, 0, this.numP * 2);
            gL.glDisableClientState(32884);
            gL.glTexEnvi(34913, 34914, 1);
            gL.glPointParameterfARB(33062, 1.5f);
            gL.glPointParameterfARB(33063, 128.0f);
            gL.glEnable(34913);
            gL.glEnableClientState(32884);
            gL.glEnableClientState(32886);
            gL.glVertexPointer(3, 5126, 0, (Buffer)this.pointBuffer);
            gL.glColorPointer(4, 5126, 0, (Buffer)this.colorBuffer);
            gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gL.glDrawArrays(0, 0, this.numP);
            gL.glDisableClientState(32884);
            gL.glDisableClientState(32886);
            gL.glDisable(34913);
            WinterBreathe.this._tex.disable();
        }
    }

    class PointHolder {
        boolean _isActive = false;
        PImage _img;
        ArrayList _points;

        PointHolder(String string) {
            this._img = WinterBreathe.this.loadImage(string);
            this._points = new ArrayList();
        }

        public void process() {
            int n = 0;
            while (n < this._img.height) {
                int n2 = 0;
                while (n2 < this._img.width) {
                    if (WinterBreathe.this.brightness(this._img.pixels[n2 + n * this._img.width]) > (float)WinterBreathe.this.COLORTHRESHOLD) {
                        this._points.add(new Vector2((float)n2 / (float)this._img.width * (float)WinterBreathe.this.width, (float)n / (float)this._img.height * (float)WinterBreathe.this.height));
                        if (this._points.size() > WinterBreathe.this.MAXPOINTS) {
                            return;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    class p {
        Vector2 _origin;
        float id;
        float _x;
        float _y;
        float _z;
        float _xp;
        float _yp;
        float _zp;
        float s;
        float d;
        float dirX;
        float dirY;
        float a;
        float aMul;
        float _speed;
        float r;
        float g;
        float b;
        float _maxTimeOnOrigin;
        float _timeOnOrigin;
        boolean pointPicked;

        public p(float f, float f2, float f3, float f4) {
            this.id = f;
            this._x = this._xp = f2;
            this._y = this._yp = f3;
            this._z = this._zp = f4;
            this.a = 0.0f;
            this.aMul = 0.0f;
            this._maxTimeOnOrigin = WinterBreathe.this.random(3.0f, 5.0f);
            this._timeOnOrigin = 0.0f;
            this._speed = 2.0f;
            this.s = WinterBreathe.this.random(1.0f, 7.0f);
            this.dirY = 1.0f;
            this.dirX = 1.0f;
            int n = (int)WinterBreathe.this.random(WinterBreathe.this.numOfColors);
            this.r = WinterBreathe.this.colors[n].r;
            this.g = WinterBreathe.this.colors[n].g;
            this.b = WinterBreathe.this.colors[n].b;
            this.pointPicked = false;
            this._origin = null;
        }

        public void update(float f) {
            this.id += 0.01f;
            this.d = (WinterBreathe.this.noise(this.id, this._x / WinterBreathe.this._mouseY + f * 0.71f, this._y / WinterBreathe.this._mouseY) - 0.5f) * WinterBreathe.this._mouseX;
            this._xp = this._x;
            this._yp = this._y;
            this._zp = this._z;
            if (this._origin != null) {
                this._x += (this._origin.x - this._x) * WinterBreathe.this.timer.getFrameTime() * 3.0f;
                this._y += (this._origin.y - this._y) * WinterBreathe.this.timer.getFrameTime() * 4.0f;
                this._z = 0.0f;
                this._origin.x += WinterBreathe.this.timer.getFrameTime() * 0.25f;
            } else {
                this._x += WinterBreathe.cos((float)WinterBreathe.radians((float)this.d)) * this.s * 0.5f * this.dirX * this._speed;
                this._y += WinterBreathe.sin((float)WinterBreathe.radians((float)(-this.d))) * this.s * 0.5f * this.dirY;
                this._z = WinterBreathe.cos((float)WinterBreathe.radians((float)this.d)) * this.s;
            }
            this._speed *= 0.95f;
            if (this._x < -1.0f) {
                this._x = this._xp = (float)(WinterBreathe.this.width + 1);
            }
            if (this._x > (float)(WinterBreathe.this.width + 1)) {
                this._xp = -1.0f;
                this._x = -1.0f;
            }
            if (this._y < -1.0f) {
                this._y = this._yp = (float)(WinterBreathe.this.height + 1);
            }
            if (this._y > (float)(WinterBreathe.this.height + 1)) {
                this._yp = -1.0f;
                this._y = -1.0f;
            }
            this.aMul += WinterBreathe.this.timer.getFrameTime() * 0.3f;
            if (this.aMul > 1.0f) {
                this.aMul = 1.0f;
            }
            this.a += this.aMul;
            if (this.a > 1.0f) {
                this.a = 1.0f;
            }
            if (this.pointPicked) {
                this._timeOnOrigin += WinterBreathe.this.timer.getFrameTime();
                if (this._timeOnOrigin >= this._maxTimeOnOrigin) {
                    this._timeOnOrigin = 0.0f;
                    this.pointPicked = false;
                    this._origin = null;
                }
            }
        }

        public void render(float f) {
            WinterBreathe.this.vgl.fill(1.0f, 0.5f);
            WinterBreathe.this.vgl.line(this._xp, this._yp, 0.0f, this._x, this._y, 0.0f);
            WinterBreathe.this.vgl.fill(this.r, this.g, this.b, 55.0f);
            WinterBreathe.this.vgl.pushMatrix();
            WinterBreathe.this.vgl.translate(this._x, this._y, this._z);
            WinterBreathe.this.vgl.rect(0.1f + this.s * 1.0f, 0.1f + this.s * 1.0f);
            WinterBreathe.this.vgl.popMatrix();
        }

        public void writePositionToBuffer(FloatBuffer floatBuffer, int n) {
            floatBuffer.put(n + 0, this._x);
            floatBuffer.put(n + 1, this._y);
            floatBuffer.put(n + 2, this._z);
        }

        public void writeColorToBuffer(FloatBuffer floatBuffer, int n) {
            floatBuffer.put(n + 0, this.r);
            floatBuffer.put(n + 1, this.g);
            floatBuffer.put(n + 2, this.b);
            floatBuffer.put(n + 3, 0.5f * this.a * this.aMul);
        }

        public void writeDirectionToBuffer(FloatBuffer floatBuffer, int n) {
            floatBuffer.put(n + 0, this._xp);
            floatBuffer.put(n + 1, this._yp);
            floatBuffer.put(n + 2, this._x);
            floatBuffer.put(n + 3, this._y);
        }
    }
}

