/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import quickhull3d.Face;
import quickhull3d.Vertex;

class HalfEdge {
    Vertex vertex;
    Face face;
    HalfEdge next;
    HalfEdge prev;
    HalfEdge opposite;

    public HalfEdge(Vertex vertex, Face face) {
        this.vertex = vertex;
        this.face = face;
    }

    public HalfEdge() {
    }

    public void setNext(HalfEdge halfEdge) {
        this.next = halfEdge;
    }

    public HalfEdge getNext() {
        return this.next;
    }

    public void setPrev(HalfEdge halfEdge) {
        this.prev = halfEdge;
    }

    public HalfEdge getPrev() {
        return this.prev;
    }

    public Face getFace() {
        return this.face;
    }

    public HalfEdge getOpposite() {
        return this.opposite;
    }

    public void setOpposite(HalfEdge halfEdge) {
        this.opposite = halfEdge;
        halfEdge.opposite = this;
    }

    public Vertex head() {
        return this.vertex;
    }

    public Vertex tail() {
        return this.prev != null ? this.prev.vertex : null;
    }

    public Face oppositeFace() {
        return this.opposite != null ? this.opposite.face : null;
    }

    public String getVertexString() {
        if (this.tail() != null) {
            return "" + this.tail().index + "-" + this.head().index;
        }
        return "?-" + this.head().index;
    }

    public double length() {
        if (this.tail() != null) {
            return this.head().pnt.distance(this.tail().pnt);
        }
        return -1.0;
    }

    public double lengthSquared() {
        if (this.tail() != null) {
            return this.head().pnt.distanceSquared(this.tail().pnt);
        }
        return -1.0;
    }
}

