/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import quickhull3d.FaceList;
import quickhull3d.HalfEdge;
import quickhull3d.InternalErrorException;
import quickhull3d.Point3d;
import quickhull3d.Vector3d;
import quickhull3d.Vertex;

class Face {
    HalfEdge he0;
    private Vector3d normal = new Vector3d();
    double area;
    private Point3d centroid = new Point3d();
    double planeOffset;
    int index;
    int numVerts;
    Face next;
    static final int VISIBLE = 1;
    static final int NON_CONVEX = 2;
    static final int DELETED = 3;
    int mark = 1;
    Vertex outside;

    public void computeCentroid(Point3d point3d) {
        point3d.setZero();
        HalfEdge halfEdge = this.he0;
        do {
            point3d.add(halfEdge.head().pnt);
        } while ((halfEdge = halfEdge.next) != this.he0);
        point3d.scale(1.0 / (double)this.numVerts);
    }

    public void computeNormal(Vector3d vector3d, double d) {
        this.computeNormal(vector3d);
        if (this.area < d) {
            System.out.println("area=" + this.area);
            HalfEdge halfEdge = null;
            double d2 = 0.0;
            HalfEdge halfEdge2 = this.he0;
            do {
                double d3;
                if (!((d3 = halfEdge2.lengthSquared()) > d2)) continue;
                halfEdge = halfEdge2;
                d2 = d3;
            } while ((halfEdge2 = halfEdge2.next) != this.he0);
            Point3d point3d = halfEdge.head().pnt;
            Point3d point3d2 = halfEdge.tail().pnt;
            double d4 = Math.sqrt(d2);
            double d5 = (point3d.x - point3d2.x) / d4;
            double d6 = (point3d.y - point3d2.y) / d4;
            double d7 = (point3d.z - point3d2.z) / d4;
            double d8 = vector3d.x * d5 + vector3d.y * d6 + vector3d.z * d7;
            vector3d.x -= d8 * d5;
            vector3d.y -= d8 * d6;
            vector3d.z -= d8 * d7;
            vector3d.normalize();
        }
    }

    public void computeNormal(Vector3d vector3d) {
        HalfEdge halfEdge = this.he0.next;
        HalfEdge halfEdge2 = halfEdge.next;
        Point3d point3d = this.he0.head().pnt;
        Point3d point3d2 = halfEdge.head().pnt;
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        vector3d.setZero();
        this.numVerts = 2;
        while (halfEdge2 != this.he0) {
            double d4 = d;
            double d5 = d2;
            double d6 = d3;
            point3d2 = halfEdge2.head().pnt;
            d = point3d2.x - point3d.x;
            d2 = point3d2.y - point3d.y;
            d3 = point3d2.z - point3d.z;
            vector3d.x += d5 * d3 - d6 * d2;
            vector3d.y += d6 * d - d4 * d3;
            vector3d.z += d4 * d2 - d5 * d;
            halfEdge = halfEdge2;
            halfEdge2 = halfEdge2.next;
            ++this.numVerts;
        }
        this.area = vector3d.norm();
        vector3d.scale(1.0 / this.area);
    }

    private void computeNormalAndCentroid() {
        this.computeNormal(this.normal);
        this.computeCentroid(this.centroid);
        this.planeOffset = this.normal.dot(this.centroid);
        int n = 0;
        HalfEdge halfEdge = this.he0;
        do {
            ++n;
        } while ((halfEdge = halfEdge.next) != this.he0);
        if (n != this.numVerts) {
            throw new InternalErrorException("face " + this.getVertexString() + " numVerts=" + this.numVerts + " should be " + n);
        }
    }

    private void computeNormalAndCentroid(double d) {
        this.computeNormal(this.normal, d);
        this.computeCentroid(this.centroid);
        this.planeOffset = this.normal.dot(this.centroid);
    }

    public static Face createTriangle(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return Face.createTriangle(vertex, vertex2, vertex3, 0.0);
    }

    public static Face createTriangle(Vertex vertex, Vertex vertex2, Vertex vertex3, double d) {
        HalfEdge halfEdge;
        Face face = new Face();
        HalfEdge halfEdge2 = new HalfEdge(vertex, face);
        HalfEdge halfEdge3 = new HalfEdge(vertex2, face);
        halfEdge2.prev = halfEdge = new HalfEdge(vertex3, face);
        halfEdge2.next = halfEdge3;
        halfEdge3.prev = halfEdge2;
        halfEdge3.next = halfEdge;
        halfEdge.prev = halfEdge3;
        halfEdge.next = halfEdge2;
        face.he0 = halfEdge2;
        face.computeNormalAndCentroid(d);
        return face;
    }

    public static Face create(Vertex[] vertexArray, int[] nArray) {
        Face face = new Face();
        HalfEdge halfEdge = null;
        for (int i = 0; i < nArray.length; ++i) {
            HalfEdge halfEdge2 = new HalfEdge(vertexArray[nArray[i]], face);
            if (halfEdge != null) {
                halfEdge2.setPrev(halfEdge);
                halfEdge.setNext(halfEdge2);
            } else {
                face.he0 = halfEdge2;
            }
            halfEdge = halfEdge2;
        }
        face.he0.setPrev(halfEdge);
        halfEdge.setNext(face.he0);
        face.computeNormalAndCentroid();
        return face;
    }

    public HalfEdge getEdge(int n) {
        HalfEdge halfEdge = this.he0;
        while (n > 0) {
            halfEdge = halfEdge.next;
            --n;
        }
        while (n < 0) {
            halfEdge = halfEdge.prev;
            ++n;
        }
        return halfEdge;
    }

    public HalfEdge getFirstEdge() {
        return this.he0;
    }

    public HalfEdge findEdge(Vertex vertex, Vertex vertex2) {
        HalfEdge halfEdge = this.he0;
        do {
            if (halfEdge.head() != vertex2 || halfEdge.tail() != vertex) continue;
            return halfEdge;
        } while ((halfEdge = halfEdge.next) != this.he0);
        return null;
    }

    public double distanceToPlane(Point3d point3d) {
        return this.normal.x * point3d.x + this.normal.y * point3d.y + this.normal.z * point3d.z - this.planeOffset;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public Point3d getCentroid() {
        return this.centroid;
    }

    public int numVertices() {
        return this.numVerts;
    }

    public String getVertexString() {
        String string = null;
        HalfEdge halfEdge = this.he0;
        do {
            string = string == null ? "" + halfEdge.head().index : string + " " + halfEdge.head().index;
        } while ((halfEdge = halfEdge.next) != this.he0);
        return string;
    }

    public void getVertexIndices(int[] nArray) {
        HalfEdge halfEdge = this.he0;
        int n = 0;
        do {
            nArray[n++] = halfEdge.head().index;
        } while ((halfEdge = halfEdge.next) != this.he0);
    }

    private Face connectHalfEdges(HalfEdge halfEdge, HalfEdge halfEdge2) {
        Face face = null;
        if (halfEdge.oppositeFace() == halfEdge2.oppositeFace()) {
            HalfEdge halfEdge3;
            Face face2 = halfEdge2.oppositeFace();
            if (halfEdge == this.he0) {
                this.he0 = halfEdge2;
            }
            if (face2.numVertices() == 3) {
                halfEdge3 = halfEdge2.getOpposite().prev.getOpposite();
                face2.mark = 3;
                face = face2;
            } else {
                halfEdge3 = halfEdge2.getOpposite().next;
                if (face2.he0 == halfEdge3.prev) {
                    face2.he0 = halfEdge3;
                }
                halfEdge3.prev = halfEdge3.prev.prev;
                halfEdge3.prev.next = halfEdge3;
            }
            halfEdge2.prev = halfEdge.prev;
            halfEdge2.prev.next = halfEdge2;
            halfEdge2.opposite = halfEdge3;
            halfEdge3.opposite = halfEdge2;
            face2.computeNormalAndCentroid();
        } else {
            halfEdge.next = halfEdge2;
            halfEdge2.prev = halfEdge;
        }
        return face;
    }

    void checkConsistency() {
        HalfEdge halfEdge = this.he0;
        double d = 0.0;
        int n = 0;
        if (this.numVerts < 3) {
            throw new InternalErrorException("degenerate face: " + this.getVertexString());
        }
        do {
            HalfEdge halfEdge2;
            if ((halfEdge2 = halfEdge.getOpposite()) == null) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "unreflected half edge " + halfEdge.getVertexString());
            }
            if (halfEdge2.getOpposite() != halfEdge) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "opposite half edge " + halfEdge2.getVertexString() + " has opposite " + halfEdge2.getOpposite().getVertexString());
            }
            if (halfEdge2.head() != halfEdge.tail() || halfEdge.head() != halfEdge2.tail()) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "half edge " + halfEdge.getVertexString() + " reflected by " + halfEdge2.getVertexString());
            }
            Face face = halfEdge2.face;
            if (face == null) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "no face on half edge " + halfEdge2.getVertexString());
            }
            if (face.mark == 3) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "opposite face " + face.getVertexString() + " not on hull");
            }
            double d2 = Math.abs(this.distanceToPlane(halfEdge.head().pnt));
            if (d2 > d) {
                d = d2;
            }
            ++n;
        } while ((halfEdge = halfEdge.next) != this.he0);
        if (n != this.numVerts) {
            throw new InternalErrorException("face " + this.getVertexString() + " numVerts=" + this.numVerts + " should be " + n);
        }
    }

    public int mergeAdjacentFace(HalfEdge halfEdge, Face[] faceArray) {
        Face face;
        Face face2 = halfEdge.oppositeFace();
        int n = 0;
        faceArray[n++] = face2;
        face2.mark = 3;
        HalfEdge halfEdge2 = halfEdge.getOpposite();
        HalfEdge halfEdge3 = halfEdge.prev;
        HalfEdge halfEdge4 = halfEdge.next;
        HalfEdge halfEdge5 = halfEdge2.prev;
        HalfEdge halfEdge6 = halfEdge2.next;
        while (halfEdge3.oppositeFace() == face2) {
            halfEdge3 = halfEdge3.prev;
            halfEdge6 = halfEdge6.next;
        }
        while (halfEdge4.oppositeFace() == face2) {
            halfEdge5 = halfEdge5.prev;
            halfEdge4 = halfEdge4.next;
        }
        HalfEdge halfEdge7 = halfEdge6;
        while (halfEdge7 != halfEdge5.next) {
            halfEdge7.face = this;
            halfEdge7 = halfEdge7.next;
        }
        if (halfEdge == this.he0) {
            this.he0 = halfEdge4;
        }
        if ((face = this.connectHalfEdges(halfEdge5, halfEdge4)) != null) {
            faceArray[n++] = face;
        }
        if ((face = this.connectHalfEdges(halfEdge3, halfEdge6)) != null) {
            faceArray[n++] = face;
        }
        this.computeNormalAndCentroid();
        this.checkConsistency();
        return n;
    }

    private double areaSquared(HalfEdge halfEdge, HalfEdge halfEdge2) {
        Point3d point3d = halfEdge.tail().pnt;
        Point3d point3d2 = halfEdge.head().pnt;
        Point3d point3d3 = halfEdge2.head().pnt;
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = point3d3.x - point3d.x;
        double d5 = point3d3.y - point3d.y;
        double d6 = point3d3.z - point3d.z;
        double d7 = d2 * d6 - d3 * d5;
        double d8 = d3 * d4 - d * d6;
        double d9 = d * d5 - d2 * d4;
        return d7 * d7 + d8 * d8 + d9 * d9;
    }

    public void triangulate(FaceList faceList, double d) {
        Face face;
        if (this.numVertices() < 4) {
            return;
        }
        Vertex vertex = this.he0.head();
        Object var6_4 = null;
        HalfEdge halfEdge = this.he0.next;
        HalfEdge halfEdge2 = halfEdge.opposite;
        Face face2 = null;
        halfEdge = halfEdge.next;
        while (halfEdge != this.he0.prev) {
            face = Face.createTriangle(vertex, halfEdge.prev.head(), halfEdge.head(), d);
            face.he0.next.setOpposite(halfEdge2);
            face.he0.prev.setOpposite(halfEdge.opposite);
            halfEdge2 = face.he0;
            faceList.add(face);
            if (face2 == null) {
                face2 = face;
            }
            halfEdge = halfEdge.next;
        }
        halfEdge = new HalfEdge(this.he0.prev.prev.head(), this);
        halfEdge.setOpposite(halfEdge2);
        halfEdge.prev = this.he0;
        halfEdge.prev.next = halfEdge;
        halfEdge.next = this.he0.prev;
        halfEdge.next.prev = halfEdge;
        this.computeNormalAndCentroid(d);
        this.checkConsistency();
        face = face2;
        while (face != null) {
            face.checkConsistency();
            face = face.next;
        }
    }
}

