/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import vitamin.math.Matrix;
import vitamin.math.Vector3;
import vitamin.math.Vector4;
import vitamin.scenesimple.Camera;
import vitamin.scenesimple.Helper;
import vitamin.scenesimple.Light;
import vitamin.scenesimple.MMVertex;
import vitamin.scenesimple.Material;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.MultiMaterial;
import vitamin.scenesimple.Object;
import vitamin.scenesimple.Scene;
import vitamin.scenesimple.StandardMaterial;
import vitamin.scenesimple.Triangle;
import vitamin.scenesimple.Vertex;

public class MMLoader {
    private static boolean DEBUG = false;
    private boolean SWAPYZ = false;
    private boolean FLIPV = true;
    FileWriter out;
    GL _gl;

    public MMLoader(GL gl) {
        this._gl = gl;
        this.out = null;
    }

    public boolean load(String filename, Scene scene, boolean swapYZ) {
        this.SWAPYZ = swapYZ;
        return this.load(filename, scene);
    }

    public boolean load(String filename, Scene scene) {
        assert (scene != null);
        FileInputStream fis = null;
        String content = "";
        try {
            fis = new FileInputStream(filename);
        }
        catch (IOException e) {
            System.err.println("(MMLoader) Couldn't load file: " + filename);
            return false;
        }
        FileChannel fc = fis.getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocate((int)fc.size());
            fc.read(bb);
            content = new String(bb.array());
        }
        catch (IOException e) {
            System.err.println("(MMLoader) Error allocation for file");
            return false;
        }
        if (DEBUG) {
            try {
                this.out = new FileWriter(new File("_vitamin_debug.txt"));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        System.out.println("(MMLoader)  Loading file " + filename);
        this.writeString("(MMLoader)  Loading file " + filename);
        if (DEBUG) {
            System.out.println("(MMLoader) Starting to parse mm file");
        }
        this.writeString("(MMLoader) Starting to parse mm file");
        String delimiters = "\n";
        StringTokenizer tokenizer = new StringTokenizer(content, delimiters);
        while (tokenizer.hasMoreTokens()) {
            String camParentName;
            Material mat;
            String token = tokenizer.nextToken();
            if (this.compare(token, "Material{")) {
                if (DEBUG) {
                    System.out.println("(MMLoader) Loading material");
                }
                this.writeString("\n_" + token);
                mat = new StandardMaterial();
                mat._type = Material.eMaterialType.STANDARD;
                Vector3 v = new Vector3();
                token = tokenizer.nextToken();
                String matName = this.readStringInQuotes(token);
                this.writeString("MatName: " + matName);
                mat._name = matName;
                token = tokenizer.nextToken();
                int ival = this.readInt1(token, "DoubleSided");
                this.writeString("doubleSided: " + ival);
                mat._doubleSided = ival != 0;
                token = tokenizer.nextToken();
                float fval = this.readFloat1(token, "Opacity");
                this.writeString("Opacity: " + fval);
                mat._opacity = fval;
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "Glossiness");
                this.writeString("Glossiness: " + fval);
                mat._glossiness = fval;
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "SpecularLevel");
                this.writeString("SpecularLevel: " + fval);
                mat._specularLevel = fval;
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Emissive");
                this.writeString("Emissive: " + v.x + ", " + v.y + ", " + v.z);
                mat._emissive.set(v, 1.0f);
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Ambient");
                this.writeString("Ambient: " + v.x + ", " + v.y + ", " + v.z);
                mat._ambient.set(v, 1.0f);
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Diffuse");
                this.writeString("Diffuse: " + v.x + ", " + v.y + ", " + v.z);
                mat._diffuse.set(v, 1.0f);
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Specular");
                this.writeString("Specular: " + v.x + ", " + v.y + ", " + v.z);
                mat._specular.set(v, 1.0f);
                token = tokenizer.nextToken();
                ival = this.readInt1(token, "Textures");
                this.writeString("Num Textures: " + ival);
                mat._numOfTextures = ival;
                int i = 0;
                while (i < ival) {
                    token = tokenizer.nextToken();
                    String tmp = this.readTextureNamesInQuotes(token);
                    if (tmp != null) {
                        mat._texNames.add(tmp);
                        this.writeString("  Texture Name : " + tmp);
                    }
                    ++i;
                }
                if (DEBUG) {
                    System.out.println("(MMLoader) Add material to scene");
                }
                scene.addMaterial(mat);
            }
            if (this.compare(token, "MultiMaterial{")) {
                if (DEBUG) {
                    System.out.println("(MMLoader) Loading multimaterial");
                }
                this.writeString("\n_" + token);
                mat = new MultiMaterial();
                ((MultiMaterial)mat)._type = Material.eMaterialType.MULTI;
                token = tokenizer.nextToken();
                String mmatName = this.readStringInQuotes(token);
                this.writeString("MultiMat Name: " + mmatName);
                ((MultiMaterial)mat)._name = mmatName;
                token = tokenizer.nextToken();
                int ival = this.readInt1(token, "NumSubMaterials");
                this.writeString("NumSubMaterials: " + ival);
                ((MultiMaterial)mat)._numSubMaterials = ival;
                int i = 0;
                while (i < ival) {
                    token = tokenizer.nextToken();
                    String mmatDelimiters = "\"\n\r";
                    StringTokenizer mmatTokenizer = new StringTokenizer(token, mmatDelimiters);
                    String mmatToken = null;
                    mmatToken = mmatTokenizer.nextToken();
                    mmatToken = mmatTokenizer.nextToken();
                    ((MultiMaterial)mat)._nameList.add(mmatToken);
                    this.writeString("MultiMat Name: " + mmatToken);
                    ++i;
                }
                if (DEBUG) {
                    System.out.println("(MMLoader) Add multimaterial to scene");
                }
                scene.addMaterial(mat);
            }
            if (this.compare(token, "Light{")) {
                if (DEBUG) {
                    System.out.println("(MMLoader) Loading light");
                }
                this.writeString("\n_" + token);
                Light lit = new Light();
                Vector3 v = new Vector3();
                token = tokenizer.nextToken();
                String camName = this.readStringInQuotes(token);
                this.writeString("Name: " + camName);
                lit._name = camName;
                token = tokenizer.nextToken();
                camParentName = this.readStringInQuotes(token);
                this.writeString("ParentName: " + camParentName);
                lit._parentName = camParentName;
                token = tokenizer.nextToken();
                if (this.compare(token, "  LocalMatrix:")) {
                    Matrix localMat;
                    lit._localMatrix = localMat = this.readMatrix3x4(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), true);
                    lit._position.reset();
                }
                token = tokenizer.nextToken();
                String ltype = this.readStringInQuotes(token);
                this.writeString("Type: " + ltype);
                if (ltype.equals("LIGHT_OMNI")) {
                    lit._type = Light.eLightTypes.LT_POINT;
                }
                if (ltype.equals("LIGHT_DIRECTIONAL")) {
                    lit._type = Light.eLightTypes.LT_DIRECTIONAL;
                }
                if (ltype.equals("LIGHT_SPOT")) {
                    lit._type = Light.eLightTypes.LT_SPOTLIGHT;
                }
                this.writeString("LightColor: " + (Object)((Object)lit._type));
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Color");
                lit._diffuse.set(v.x, v.z, v.y, 1.0f);
                this.writeString("LightColor: " + v.x + ", " + v.y + ", " + v.z);
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Direction");
                if (this.SWAPYZ) {
                    this.writeString("LightDirection: " + v.x + ", " + v.z + ", " + v.y);
                    lit._direction.set(v.x, v.z, v.y, 1.0f);
                } else {
                    this.writeString("LightDirection: " + v.x + ", " + v.y + ", " + v.z);
                    lit._direction.set(v, 1.0f);
                }
                token = tokenizer.nextToken();
                float fval = this.readFloat1(token, "Intensity");
                this.writeString("Intensity: " + fval);
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "SpotInnerAngle");
                this.writeString("SpotInnerAngle: " + fval);
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "SpotOuterAngle");
                this.writeString("SpotOuterAngle: " + fval);
                token = tokenizer.nextToken();
                ltype = this.readStringInQuotes(token);
                this.writeString("ProjectionMap: " + ltype);
                token = tokenizer.nextToken();
                ltype = this.readStringInQuotes(token);
                this.writeString("DecayType: " + ltype);
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "DecayRadius");
                this.writeString("DecayRadius: " + fval);
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "ShadowColor");
                this.writeString("ShadowColor: " + v.x + ", " + v.y + ", " + v.z);
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "ShadowDensity");
                this.writeString("ShadowDensity: " + fval);
                if (DEBUG) {
                    System.out.println("(MMLoader) Add light to scene");
                }
                scene.addLight(lit);
            }
            if (this.compare(token, "Camera{")) {
                if (DEBUG) {
                    System.out.println("(MMLoader) Loading camera");
                }
                this.writeString("\n_" + token);
                Camera cam = new Camera();
                Vector3 v = new Vector3();
                token = tokenizer.nextToken();
                String camName = this.readStringInQuotes(token);
                this.writeString("Name: " + camName);
                cam._name = camName;
                token = tokenizer.nextToken();
                camParentName = this.readStringInQuotes(token);
                this.writeString("ParentName: " + camParentName);
                cam._parentName = camParentName;
                token = tokenizer.nextToken();
                if (this.compare(token, "  LocalMatrix:")) {
                    Matrix localMat;
                    cam._localMatrix = localMat = this.readMatrix3x4(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), true);
                    cam._position.x = cam._localMatrix._M[12];
                    cam._position.y = cam._localMatrix._M[13];
                    cam._position.z = cam._localMatrix._M[14];
                }
                token = tokenizer.nextToken();
                String camType = this.readStringInQuotes(token);
                this.writeString("Camera Type: " + camType);
                cam._type = camType;
                token = tokenizer.nextToken();
                float fval = this.readFloat1(token, "FOV");
                this.writeString("FOV: " + fval);
                cam._fovy = fval;
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "Near");
                this.writeString("NearPlane: " + fval);
                cam._nearPlane = fval;
                token = tokenizer.nextToken();
                fval = this.readFloat1(token, "Far");
                this.writeString("FarPlane: " + fval);
                cam._farPlane = fval;
                token = tokenizer.nextToken();
                v = this.readFloat3(token, "Direction");
                if (this.SWAPYZ) {
                    this.writeString("CamDirection: " + v.x + ", " + v.z + ", " + v.y);
                    cam._dir.set(v.x, v.z, v.y);
                } else {
                    this.writeString("CamDirection: " + v.x + ", " + v.y + ", " + v.z);
                    cam._dir.set(v);
                }
                token = tokenizer.nextToken();
                String tName = this.readStringInQuotes(token);
                this.writeString("Target Name: " + tName);
                cam._targetName = tName;
                token = tokenizer.nextToken();
                String tParentName = this.readStringInQuotes(token);
                this.writeString("Target ParentName: " + tParentName);
                cam._targetParentName = tParentName;
                token = tokenizer.nextToken();
                if (this.compare(token, "  LocalMatrix:")) {
                    Matrix localMat;
                    cam._targetLocalMatrix = localMat = this.readMatrix3x4(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), true);
                    cam._target.x = cam._targetLocalMatrix._M[12];
                    cam._target.y = cam._targetLocalMatrix._M[13];
                    cam._target.z = cam._targetLocalMatrix._M[14];
                }
                cam._position.reset();
                cam._target.reset();
                if (DEBUG) {
                    System.out.println("(MMLoader) Add camera to scene");
                }
                scene.addCamera(cam);
            }
            if (this.compare(token, "Helper{")) {
                if (DEBUG) {
                    System.out.println("(MMLoader) Loading helper");
                }
                this.writeString("\n_" + token);
                Helper help = new Helper();
                help._type = Object.eObjectType.HELPER;
                token = tokenizer.nextToken();
                String name = this.readStringInQuotes(token);
                this.writeString("Name: " + name);
                help._name = name;
                token = tokenizer.nextToken();
                name = this.readStringInQuotes(token);
                this.writeString("ParentName: " + name);
                help._parentName = name;
                token = tokenizer.nextToken();
                if (this.compare(token, "  LocalMatrix:")) {
                    Matrix localMat;
                    help._localMatrix = localMat = this.readMatrix3x4(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), true);
                }
                if (DEBUG) {
                    System.out.println("(MMLoader) Add helper to scene");
                }
                scene.addHelper(help);
            }
            if (!this.compare(token, "Mesh{")) continue;
            if (DEBUG) {
                System.out.println("(MMLoader) Loading mesh");
            }
            this.writeString("\n_" + token);
            Mesh mesh = new Mesh();
            mesh._type = Object.eObjectType.MESH;
            token = tokenizer.nextToken();
            String meshName = this.readStringInQuotes(token);
            this.writeString("Name: " + meshName);
            mesh._name = meshName;
            token = tokenizer.nextToken();
            String meshParentName = this.readStringInQuotes(token);
            this.writeString("ParentName: " + meshParentName);
            mesh._parentName = meshParentName;
            token = tokenizer.nextToken();
            if (this.compare(token, "  LocalMatrix:")) {
                Matrix localMat;
                mesh._localMatrix = localMat = this.readMatrix3x4(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), true);
            }
            token = tokenizer.nextToken();
            String meshMatName = this.readStringInQuotes(token);
            this.writeString("Material Name: " + meshMatName);
            mesh._matName = meshMatName;
            token = tokenizer.nextToken();
            int ival = this.readInt1(token, "NumTexChannels");
            this.writeString("NumTexChannels: " + ival);
            if (ival > 1) {
                System.err.println("(MMLoader) Warning: " + filename + " mesh has more than 1 tex channels. we do not support it!!");
            }
            Vector3 row1 = new Vector3(mesh._localMatrix._M[0], mesh._localMatrix._M[1], mesh._localMatrix._M[2]);
            Vector3 row2 = new Vector3(mesh._localMatrix._M[4], mesh._localMatrix._M[5], mesh._localMatrix._M[6]);
            Vector3 row3 = new Vector3(mesh._localMatrix._M[8], mesh._localMatrix._M[9], mesh._localMatrix._M[10]);
            Vector3 cross = Vector3.cross(row2, row1);
            float scaling = cross.dot(row3);
            token = tokenizer.nextToken();
            ival = this.readInt1(token, "Triangles");
            this.writeString("Triangles: " + ival);
            int i = 0;
            while (i < ival) {
                Triangle t;
                token = tokenizer.nextToken();
                Vector4 v4 = this.readFaceData(token);
                if (scaling < 0.0f) {
                    this.writeString((int)v4.z + " " + (int)v4.y + " " + (int)v4.x + " " + (int)v4.w);
                    t = new Triangle((int)v4.z, (int)v4.y, (int)v4.x);
                    t._matId = (int)v4.w;
                    mesh.addTriangle(t);
                } else {
                    t = new Triangle((int)v4.x, (int)v4.y, (int)v4.z);
                    t._matId = (int)v4.w;
                    mesh.addTriangle(t);
                }
                ++i;
            }
            token = tokenizer.nextToken();
            ival = this.readInt1(token, "Vertices");
            this.writeString("Vertices: " + ival);
            i = 0;
            while (i < ival) {
                token = tokenizer.nextToken();
                MMVertex vert = this.readVertexData(token);
                Vertex v = new Vertex();
                v._index = vert.index;
                v._position.set(vert.pos);
                v._normal.set(vert.norm);
                v._color.set(vert.color, 1.0f);
                v._texCoord.set(vert.texcoord.x, vert.texcoord.y);
                this.writeString(String.valueOf(v._index) + "-- " + v._position.x + " " + v._position.y + " " + v._position.z + " " + v._normal.x + " " + v._normal.y + " " + v._normal.z + " " + v._color.x + " " + v._color.y + " " + v._color.z + " " + v._texCoord.x + " " + v._texCoord.y);
                mesh.addVertex(v);
                ++i;
            }
            mesh._hasNormals = true;
            mesh._hasTangents = false;
            mesh._isVisible = true;
            if (DEBUG) {
                System.out.println("(MMLoader) Add mesh to scene");
            }
            scene.addMesh(mesh);
        }
        System.out.println("(MMLoader)  Processing scene...");
        scene.process();
        System.out.println("(MMLoader)  Finished loading: " + filename);
        return true;
    }

    String readTextureNamesInQuotes(String token) {
        String namesDelimiters = "\"\n\r";
        StringTokenizer namesTokenizer = new StringTokenizer(token, namesDelimiters);
        String namesToken = null;
        namesToken = namesTokenizer.nextToken();
        namesToken = namesTokenizer.nextToken();
        namesToken = namesTokenizer.nextToken();
        namesToken = namesTokenizer.nextToken();
        return namesToken;
    }

    MMVertex readVertexData(String token) {
        String Delimiters = " \n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        int idx = Integer.parseInt(Tokenizer.nextToken());
        float px = Float.parseFloat(Tokenizer.nextToken());
        float py = Float.parseFloat(Tokenizer.nextToken());
        float pz = Float.parseFloat(Tokenizer.nextToken());
        float nx = Float.parseFloat(Tokenizer.nextToken());
        float ny = Float.parseFloat(Tokenizer.nextToken());
        float nz = Float.parseFloat(Tokenizer.nextToken());
        float r = Float.parseFloat(Tokenizer.nextToken());
        float g = Float.parseFloat(Tokenizer.nextToken());
        float b = Float.parseFloat(Tokenizer.nextToken());
        float u0 = Float.parseFloat(Tokenizer.nextToken());
        float v0 = Float.parseFloat(Tokenizer.nextToken());
        MMVertex v = new MMVertex();
        v.index = idx;
        if (this.SWAPYZ) {
            v.pos.set(px, pz, py);
        } else {
            v.pos.set(px, py, pz);
        }
        if (this.SWAPYZ) {
            v.norm.set(nx, nz, ny);
        } else {
            v.norm.set(nx, ny, nz);
        }
        v.color.set(r, g, b);
        if (this.FLIPV) {
            v.texcoord.set(u0, v0);
        } else {
            v.texcoord.set(u0, 1.0f - v0);
        }
        return v;
    }

    Vector4 readFaceData(String token) {
        String Delimiters = " \n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        int x = Integer.parseInt(Tokenizer.nextToken());
        int y = Integer.parseInt(Tokenizer.nextToken());
        int z = Integer.parseInt(Tokenizer.nextToken());
        int w = Integer.parseInt(Tokenizer.nextToken());
        Vector4 v = new Vector4(x, y, z, w);
        return v;
    }

    String readStringInQuotes(String token) {
        String namesDelimiters = "\"\n\r";
        StringTokenizer namesTokenizer = new StringTokenizer(token, namesDelimiters);
        String namesToken = null;
        try {
            namesToken = namesTokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        try {
            namesToken = namesTokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return namesToken;
    }

    int readInt1(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return -1;
        }
        Token = Tokenizer.nextToken();
        int val = -1;
        try {
            val = Integer.parseInt(Token);
        }
        catch (NumberFormatException e) {
            this.println(e.toString());
        }
        return val;
    }

    Vector3 readInt3(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return null;
        }
        int x = Integer.parseInt(Tokenizer.nextToken());
        int y = Integer.parseInt(Tokenizer.nextToken());
        int z = Integer.parseInt(Tokenizer.nextToken());
        Vector3 v = new Vector3(x, y, z);
        return v;
    }

    Vector4 readInt4(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return null;
        }
        int x = Integer.parseInt(Tokenizer.nextToken());
        int y = Integer.parseInt(Tokenizer.nextToken());
        int z = Integer.parseInt(Tokenizer.nextToken());
        int w = Integer.parseInt(Tokenizer.nextToken());
        Vector4 v = new Vector4(x, y, z, w);
        return v;
    }

    float readFloat1(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return -1.0f;
        }
        float val = Float.parseFloat(Tokenizer.nextToken());
        return val;
    }

    Vector3 readFloat2(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return null;
        }
        float x = Float.parseFloat(Tokenizer.nextToken());
        float y = Float.parseFloat(Tokenizer.nextToken());
        Vector3 v = new Vector3(x, y, 0.0f);
        return v;
    }

    Vector3 readFloat3(String token, String desc) {
        String Delimiters = " :\n\r";
        StringTokenizer Tokenizer = new StringTokenizer(token, Delimiters);
        String Token = Tokenizer.nextToken();
        if (!Token.equals(desc)) {
            return null;
        }
        float x = Float.parseFloat(Tokenizer.nextToken());
        float y = Float.parseFloat(Tokenizer.nextToken());
        float z = Float.parseFloat(Tokenizer.nextToken());
        Vector3 v = new Vector3(x, y, z);
        return v;
    }

    Matrix readMatrix3x4(String token0, String token1, String token2, String token3, boolean convertMat) {
        String Delimiters = " \n\r";
        StringTokenizer Tokenizer = null;
        Tokenizer = new StringTokenizer(token0, Delimiters);
        float m0 = Float.parseFloat(Tokenizer.nextToken());
        float m1 = Float.parseFloat(Tokenizer.nextToken());
        float m2 = Float.parseFloat(Tokenizer.nextToken());
        float m3 = 0.0f;
        Tokenizer = new StringTokenizer(token1, Delimiters);
        float m4 = Float.parseFloat(Tokenizer.nextToken());
        float m5 = Float.parseFloat(Tokenizer.nextToken());
        float m6 = Float.parseFloat(Tokenizer.nextToken());
        float m7 = 0.0f;
        Tokenizer = new StringTokenizer(token2, Delimiters);
        float m8 = Float.parseFloat(Tokenizer.nextToken());
        float m9 = Float.parseFloat(Tokenizer.nextToken());
        float m10 = Float.parseFloat(Tokenizer.nextToken());
        float m11 = 0.0f;
        Tokenizer = new StringTokenizer(token3, Delimiters);
        float m12 = Float.parseFloat(Tokenizer.nextToken());
        float m13 = Float.parseFloat(Tokenizer.nextToken());
        float m14 = Float.parseFloat(Tokenizer.nextToken());
        float m15 = 1.0f;
        Matrix m = new Matrix();
        m._M[0] = m0;
        m._M[1] = m1;
        m._M[2] = m2;
        m._M[3] = m3;
        m._M[4] = m4;
        m._M[5] = m5;
        m._M[6] = m6;
        m._M[7] = m7;
        m._M[8] = m8;
        m._M[9] = m9;
        m._M[10] = m10;
        m._M[11] = m11;
        m._M[12] = m12;
        m._M[13] = m13;
        m._M[14] = m14;
        m._M[15] = m15;
        if (convertMat) {
            Matrix convert = new Matrix();
            convert._M[0] = 1.0f;
            convert._M[1] = 0.0f;
            convert._M[2] = 0.0f;
            convert._M[4] = 0.0f;
            convert._M[5] = 0.0f;
            convert._M[6] = -1.0f;
            convert._M[8] = 0.0f;
            convert._M[9] = 1.0f;
            convert._M[10] = 0.0f;
            m = m.mulColumnMajor(convert);
        }
        return m;
    }

    Matrix readMatrix3x4_2(String token0, String token1, String token2, String token3, boolean convertMat) {
        String Delimiters = " \n\r";
        StringTokenizer Tokenizer = null;
        Tokenizer = new StringTokenizer(token0, Delimiters);
        float m0 = Float.parseFloat(Tokenizer.nextToken());
        float m1 = Float.parseFloat(Tokenizer.nextToken());
        float m2 = Float.parseFloat(Tokenizer.nextToken());
        float m3 = 0.0f;
        Tokenizer = new StringTokenizer(token1, Delimiters);
        float m4 = Float.parseFloat(Tokenizer.nextToken());
        float m5 = Float.parseFloat(Tokenizer.nextToken());
        float m6 = Float.parseFloat(Tokenizer.nextToken());
        float m7 = 0.0f;
        Tokenizer = new StringTokenizer(token2, Delimiters);
        float m8 = Float.parseFloat(Tokenizer.nextToken());
        float m9 = Float.parseFloat(Tokenizer.nextToken());
        float m10 = Float.parseFloat(Tokenizer.nextToken());
        float m11 = 0.0f;
        Tokenizer = new StringTokenizer(token3, Delimiters);
        float m12 = Float.parseFloat(Tokenizer.nextToken());
        float m13 = Float.parseFloat(Tokenizer.nextToken());
        float m14 = Float.parseFloat(Tokenizer.nextToken());
        float m15 = 1.0f;
        Matrix m = new Matrix();
        m._M[0] = m0;
        m._M[1] = m1;
        m._M[2] = m2;
        m._M[3] = m3;
        m._M[4] = m4;
        m._M[5] = m5;
        m._M[6] = m6;
        m._M[7] = m7;
        m._M[8] = m8;
        m._M[9] = m9;
        m._M[10] = m10;
        m._M[11] = m11;
        m._M[12] = m12;
        m._M[13] = m13;
        m._M[14] = m14;
        m._M[15] = m15;
        return m;
    }

    boolean compare(String str1, String str2) {
        return str1.equals(String.valueOf(str2) + "\r");
    }

    void writeString(String content) {
        if (DEBUG) {
            try {
                content = String.valueOf(content) + " ";
                this.out.write(String.valueOf(content) + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void println(String str) {
        System.out.println(str);
    }
}

