	;
	; Rockstar ate my border
	; by Csabo of LOD, 2009 for limiTED2
	;
	; Greets to all Plus/4 sceners
	;
	; Big thanks to Chronos and Csio for
	; last minute testing and moral support :-)
	;
	ORG $1001 - 2
	DW  $1001
	DB $0B,$10,$60,0,$9E,"4109",0,0,0

dest	= $07
HorizScan = $FF1E	; $20 for testing, final $1E

value1		= $7E
value2		= $5C
value3		= $2E

tick	= $C0
note	= $C1
temp	= $C2
speed	= $C3
snare	= $C4
vol	= $C5
ptr	= $3B

ptr2	= $E0

	;
	; *** Start ***
	;
	DEX
	STX note
	;
	LDA #$05
	STA speed
	STA tick
	;
	LDA #$80
	STA ptr
	STA ptr+1
	;
	SEI
	;
il_01	TYA
	AND #$07
	TAX
	LDA pattern,x
	STA (dest),y		; kill mem from $2000
	INY
	BNE il_01
	INC dest+1
	BPL il_01		; stop at $8000
	;
	STA $FF3F
	;
sync_01	CPY $FF1D
	BNE sync_01
	;
	STY $FF19
	;
	ASL $FF09
	;
	LDA $FF0A
	ORA #$01
	STA $FF0A
	LDA #$0C
	STA $FF0B
	;
	LDA #irq1 & 255
	STA $FFFE	; NMI Vector Lo Byte
	LDA #irq1 >> 8
	STA $FFFF	; NMI Vector Hi Byte
	;
	LDA #$3B
	STA $FF06	; screen on
	LDA $FF07
	AND #$40
	ORA #$98
	STA $FF07	; multicolor
	;
	CLI
	;
	JMP *		; no main program
	;
	; #################################################################
	;
	
irq1	
value4	LDA #$10
syn_01	CMP $FF1D
	BNE syn_01
	;
value5	LDA #$31	; skip raster lines: raise screen!
	STA $FF1D
	;
	LDA $FF0A
	AND #$FE
	STA $FF0A
	;
ntsc3	LDA #$05
	STA $FF0B
	;
	ASL $FF09
	;
	LDA #irq2 & 255
	STA $FFFE
	;
	RTI

irq2
	ASL $FF09	; Clear IRQ
	INC $FF0B	; Cause next irq right away
	;
	LDA #irq3 & 255
	STA $FFFE	; inc IRQ Vector Hi Byte
	;     
	; 132 cycles
	LDX #23		; 2
	JSR delay04
	;
	RTI

irq3
	LDX #7		; 52
	JSR delay04
	;
	LDY #$00	; y=0, loop counter
	;
mainloop
	LDA #$08	; 6
	STA $FF1D
	;
v1	LDA #value1	; 6
	STA HorizScan
	;
	LDA #value2	; 6
	STA HorizScan
	;
	LDA #$49
	STA $FF15
	LDA #$67
	STA $FF16
	;
	LDA #value3	; 6
	STA HorizScan
	;
	;LDX 
	JSR delay22
	;
	INY		; 2
value6	CPY #244	; 2
	BNE mainloop	; 3
	;
	;		; 6+6+6+12+6+22+2+2+3 = 65 cycles
	;
	JSR delay12
	;
	LDA #$00
	STA $FF15
	STA $FF16          
	;
	LDA $FF1D
sync_02	CMP $FF1D
	BEQ sync_02
	;
value7	LDA #$C9	; adjust bottom of picture
	STA $FF1D	; Vert Scan
	;
	LDA #$DB
	STA $FF12	; set page to $8000 (black area on top)
	;
	LDA #irq1 & 255
	STA $FFFE	; NMI Vector Hi Byte
	;
	ASL $FF09	; clear IRQ
	;
	LDA $FF0A
	ORA #$01
	STA $FF0A
	LDA #$0C
	STA $FF0B	; Vert raster
	;
	; --- self-mod for init
	;
	LDA v1+1
	CMP #value1	; setting to $80 causes a problem, so start with $7E for one frame
	BNE b_03	; and then set it
	;
	LDA #$80
	STA v1+1
b_03	;
	; ---
	;     
	; ########################################################
	;
	STA $FF3E           
	;
	INC tick
	LDA tick
	CMP speed
	BCS new_note
	JMP no_new_note
	;
new_note
txt_ptr	LDX #$00
	CPX #$16
	BEQ skipchr
	;
	INC txt_ptr+1
	LDA txt,x
	BEQ skipchr	; zero (space) is skipped
	STA ptr2
	LDA #$d0	; ROM address: $D0##
	STA ptr2+1
	;
	LDY #$07	; copy one character to the screen (8 bytes)
copychr	LDA (ptr2),y
	AND #$55
ptr3	STA $7030,y
	DEY
	BPL copychr
	;
skipchr	LDA ptr3+1
	CLC
	ADC #$08
	STA ptr3+1
	;
	INC note
	LDA note
	AND #$7F
	TAX
	BNE no_new_seq
	;
	LDA ptr
	CLC
	ADC #$10
	STA ptr
	BCC *+4
	INC ptr+1
	;
	LDY #$05
	LDA (ptr),y
	AND #$13
	EOR #$35
	STA vol
	;
no_new_seq
	;
	LDA #$00	; reset tick and snare flag
	STA snare
	STA tick
	;
	TXA
	LSR a
	LSR a
	PHA
	LSR a
	LSR a
	LSR a
	TAY
	LDA bass,y	; look up freq (one byte only)
	STA $FF0F
	AND #$01	; lowest bit reused as highest
	STA $FF10
	;    
	TXA
	AND #$3F
	TAY
	LDA $F83D,y	; the drums are in the ROM :-)
	ORA $F3D2,y	; I know, this part is quite incredible
	BPL no_snare	; $80 is the flag for snare
	;
	LDA #$E3	; freq (same low & high byte)
	STA $FF0F
	STA $FF10
	LDA #$60	; snare flag
	STA snare
	;
no_snare
	PLA
	AND #$18
	STA temp	; this holds a value added to the lead index
	;		; something like beat * 8                                                    	
	TXA
	AND #$0F
	TAY
	;
	LDA (ptr),y	; get a "random" value from the ROM
	AND #$07	; use only lowest 3 bits
	CLC
	ADC temp	; make sure we're in the right chord
	TAX
	LDA lead1,x	; look up low byte (high byte is $03 for all lead notes)
	STA $FF0E
	;
	LDA speed	; swing tempo
	EOR #$0D
	STA speed
	;
no_new_note
	LDA tick
	EOR vol
	EOR snare
	STA $FF11
	;
	STA $FF3F
	;
	RTI

	;
	; Take up X number of cycles
	;
	; formula: 2 + 6 + 6 + X * 5 - 1
	;          13 + X * 5
	;
	; x=1: 18 cycles
	; x=2: 23 cycles 
	;
delay22	LDX #$01
delay04	NOP
	NOP
delay	DEX
	BNE delay
delay12	RTS		; +12

pattern
	;DB $0F,$0F,$3C,$3C,$F0,$F0,$C3,$C3
	DB $23,$23,$8C,$8C,$32,$32,$C8,$C8
	
	; --------------------------------------------------------
	; the bass
	;
	; freq stored on only one byte
	; lowest bit reused for highest bit
	;
	; $40 -> $0040 (C)
	; $31 -> $0131 (F)
	; $7F -> $017F (G)
	;
	;   C,  C,  C,  C   F   F   G   G
bass	DB $40,$40,$31,$7F

	; --------------------------------------------------------
	; the lead                    
	;	
lead1	DB $FE,$10,$36,$2A,$79,$60,$88,$FE	; c d d# g  a# C
lead2	DB $FE,$10,$36,$2A,$79,$69,$88,$FE	; c d d# g# a# C
lead3	DB $FE,$10,$4C,$2A,$79,$69,$88,$FE	; c d f  g# a# C
lead4	DB $FE,$02,$4C,$2A,$71,$60,$81,$FE	; b d f  g  a  b

txt
	cmap "A",$08,$10,$18,$20,$28,$30,$38,$40,$48,$50,$58,$60,$68,$70,$78,$80,$88,$90,$98,$A0,$A8,$B0,$B8,$C0,$C8,$D0,$D8,$E0,$E8
	cmap " ",$00
	DB "ROCKSTAR ATE MY BORDER"

;[eof]
