;
; Vertical Bars
;
; Start with SYS4109
; Coded by Csabo of LOD in 2009 for limiTED2
;
	ORG $100D-2
	DW  $100D

zp_7	= $7D		; any zeropage value that is seven
colors	= $1100		; anywhere that is a page boundary

	;DW $100B,0
	;DB $9E,"4109",0,0,0
	
	SEI		; disable interrupts
	STA $FF06	; turn screen off
	;
	LDA $FF07	; make it NTSC compatible, at the cost of 3+2+2+2+3 = 12 bytes! 
	AND #$40	; if this was removed, there would be room for the basic line with SYS
	BEQ PAL
	LDA #131
	STA main+1
PAL	;
	;
copycol	LDA cols-1,y	; copy the colors in a backwards loop
	STA colors-1,y	; to a page boundary (necessary due to AND $0F)
	DEY
	BNE copycol	; the last byte copied will be the first byte of the table
	;       
presync	CMP $FF1D	; A=$F6 (first color), so sync to that line. $F6 works for both PAL and NTSC
	BNE presync
	;       
	NOP
	LDX #$0F	; horizontal positioning
	BNE w1		; always jump
	;
eos	;
	; ---
	;
	INC $E0,X	; X=0 here. The indexing is not necessary, but it adds one cycle
	LDA $E0,X	; again add one more cycle
	CMP #13		; skip to next color at every 13th frame
	BNE no_skip
	;
	STX $E0		; X=0, reset counter
	;
	LDA raster1+1	; increment color pointer (self-modifying code)
	ADC #$00	; Carry is always set, so this is A=A+1
	AND #$0F	; limit to 16 colors
	STA raster1+1
	STA raster2+1
	;
	STA $FF10	; play some sounds
	ORA #$20
	STA $FF11
	;     
	LDX #$08	; timing for skip frames
	DB $2C
no_skip	LDX #$11	; timing for normal frames
w1	DEX		; Each loop takes 5 cycles
	BPL w1
	;
main	LDX #156	; number of rows / 2, so 156*2 = 312 (PAL) lines will be painted
	;		; 131 * 2 = 262 lines on NTSC
 	;
rowloop	LDY zp_7	; this needs to be 3 cycles, hence the zero page instead of immediate
	;		; Y=7, so loop 8 times
raster1	LDA colors,y	; (4) one loop takes 4+4+2+3 = 13 cycles
	STA $FF19	; (4)
	DEY		; (2)
	BPL raster1    	; (3) branch taken
	;		; 2 + 8*13 - 1 = 105 cycles, which leaves 4 cycles!
	;  
	DEX		; the end of loop check is done inside,
	BEQ eos		; so that normally the branch will not be taken (only 2 cycles)
	;
    	LDY #$07	; again loop 8 times, takes 105 cycles
raster2	LDA colors,y
	STA $FF19
	DEY
	BPL raster2
	;
	BMI rowloop	; this branch only takes 3 cycles
	;		; it would be possible to make a 4 cycle jump, if it crossed a page boundary
	;	
cols	DB $FC,$65,$5A,$47,$39,$28,$12,$0B,$04,$14,$2E,$36,$46,$53,$63,$73
	DB $FC,$65,$5A,$47,$39,$28,$12		; plus repeat 7 bytes
;eof
