; sinx+siny - for the limiTED2 128 byte competition
; done by Wolfram Sang (Ninja/The Dreams) in 2009
; to be assembled with DreamAss (http://noname.c64.org/csdb/release/?id=14608)
; not so much comments this time, sorry.
; there is a _lot_ of implicit timing in here; you will surely notice when you change something :)

	.cpu "6510ill"
	.setpet
	* = $1001

first_line	= $102
last_line	= $ff
delta_per_frame = <($138 - (first_line - last_line)) + 1

ted_ctrl1	= $ff06
ted_keycol	= $ff08
ted_charmap	= $ff13
ted_bordercol	= $ff19
ted_rasylow	= $ff1d
ted_allram	= $ff3f

zp_02		= $2a
bas_linenr	= $39
sine		= $0c00

var	= 'i'
	.dw next_line, ted_keycol
	.text $81,var,$b2,"3072",$a4,"3327:"
	.text $97,var,",255",$af,$be,"(",var,$ad,"40.7)",$ac,"1888:"
	.text $82,":"
	.text $9e,"4146"
	.db 0
next_line:
	.db 0,0			; lo-byte must be 0, too :(

	sei
	lda #$c7		; value should be after last badline and before lower border
	sta ted_charmap		; & we need the slowclock bit for a constant ghostbyte
endless:
	cmp ted_rasylow
	bne endless
	sta ted_bordercol
line_loop:			; one line = 57 cycles
	sta ted_allram		; odd, ghostbyte is RAM/ROM sensitive
	lda sine,x
	adc sine,y
	inx
	iny
	txs
	lsr
	lsr
	lsr
	lsr
	lsr
	tax
	lda pattern,x
	tsx
	sta $ffff

	lda ted_rasylow
	cmp #last_line
	and #$0f
	eor #$48		; ECM skips the flash attribute
	sta ted_ctrl1
	bcc line_loop

	tya
	sbc #delta_per_frame + 2
	sec
	isc (bas_linenr - (2 + delta_per_frame),x)	; write latch and subtract keyval
	tay						; assuming $fd30 = 0
	lax zp_02		; = #<first_line
	bne endless

pattern:
	.db $f0,$78,$3c,$1e,$0f,$87,$c3,$e1

