import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class Planearium extends PApplet {

/**
 * Create Image. 
 * 
 * The createImage() function provides a fresh buffer of pixels to play with.
 * This example creates an image gradient.
 */

PImage img;
PGraphics pg;

int screen_w = 640;
int screen_h = 360;

int iter;
float x, y, z, offset_x, offset_y, persp_z;
float avg_x, avg_y, avg_z;
int col_r, col_g, col_b;

float[] m =
{
  1, 0, 0,
  0, 1, 0,
  0, 0, 1,
};  

float[] p =
{
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

int preset, num_presets = 5;
float[] p2 =
{
  -0.653165f, -0.972152f, -0.713924f, -0.481000f,  0.516458f, -0.592405f,
  -0.268000f,  0.827000f,  0.379747f, -0.943000f, -0.072000f,  1.200000f,
  -0.470000f,  0.041000f,  0.000000f,  0.914000f, -0.531646f,  0.364557f,

  -0.333f,  0.290f, -0.815f, -1.127f, -0.479f,  1.049f, 
   0.857f,  0.252f, -0.772f,  1.066f, -0.384f,  0.260f,
   0.296f, -0.655f, -0.832f,  0.118f, -1.098f,  0.059f,

  -0.325f, -1.158f, -0.448f,  0.229f,  0.042f, -0.850f, 
  -0.349f,  1.048f,  1.063f,  0.319f,  0.865f,  0.507f,
   0.168f,  0.353f,  0.584f, -0.043f,  0.903f, -0.876f,

-0.076f, 0.251f, -0.294f, -0.83f,
	            -0.951f, 0.755f, -0.782f, 0.645f,
	            0.828f, -0.932f, -0.504f, 0.794f,
	            1.034f, 0.078f, -0.344f, -0.39f,
	            -0.078f, 0.511f,

1.099f, 0.07f, -0.53f, -0.657f,
	            -0.646f, -0.414f, -1.062f, 0.494f,
	            0.016f, -0.863f, 1.008f, -0.057f,
	            0.331f, 1.046f, -0.587f, 0.07f,
	            0.176f, 0.511f,
};

public void gen_params()
{
  iter = 0;
  x = y = z = 0;
  offset_x = random(screen_w/2) - screen_w/4;
  offset_y = random(screen_h/5) - screen_h/10;
  persp_z = random(1)+0.5f;
  avg_x = avg_y = avg_z = 0;
  col_r = round(63 + random(192));
  col_g = round(63 + random(192));
  col_b = round(63 + random(192));

  float a1 = random(2*3.1415926f);
  float a2 = random(2*3.1415926f);
  m[0] = cos(a1);
  m[1] = 0;
  m[2] = sin(a1);
  m[3] = sin(a1)*sin(a2);
  m[4] = cos(a2);
  m[5] = -cos(a1)*sin(a2);
  m[6] = -sin(a1)*cos(a2);
  m[7] = sin(a2);
  m[8] = cos(a1)*cos(a2);

  preset = round(random(num_presets-1));
  for (int i=0; i<18; i++)
    p[i] = p2[preset*12 + i];
}

public void setup() 
{
  size(screen_w, screen_h);  
  background(0);
  pg = createGraphics(screen_w, screen_h, P2D);
  pg.background(0);

  gen_params();
}

public int clerp(int c1, int w1, int c2, int w2)
{
  return color(
    min(255, (((c1 >> 16) & 0xFF) * w1 + ((c2 >> 16) & 0xFF) * w2) >> 8),
    min(255, (((c1 >>  8) & 0xFF) * w1 + ((c2 >>  8) & 0xFF) * w2) >> 8),
    min(255, (((c1      ) & 0xFF) * w1 + ((c2      ) & 0xFF) * w2) >> 8));
}

public int darken(int c1, int amount)
{
  int r = (c1 >> 16) & 0xFF;
  int g = (c1 >>  8) & 0xFF;
  int b = (c1      ) & 0xFF;
  r = r - (amount*r*r*r >> 24) - 1;
  g = g - (amount*g*g*g >> 24) - 1;
  b = b - (amount*b*b*b >> 24) - 1;
  return color(r, g, b);
}

public void draw() 
{
  pg.beginDraw();
  pg.noFill();

  for (int i = 0; i < screen_w*screen_h; i++)
    pg.pixels[i] = darken(pg.pixels[i], 7);

  // p[8] += 0.001;

  iter++;
  if (keyPressed || iter > 40)
    gen_params();
    
  int rp = round(random(17));
  p[rp] += random(0.01f)-0.005f;
  p[12] += 0.0001f;
  
  // iterate
  int pix = 0, max_it = 10000;
  for (int it=0; it<max_it; it++)
  {
    float x0=x, y0=y, z0=z;
    x = p[0]  + x0 * (p[1]  + p[2]*x0  + p[3]*y0)  + y0 * (p[4] + p[5]*y0);
    y = p[6]  + y0 * (p[7]  + p[8]*y0  + p[9]*z0)  + z0 * (p[10] + p[11]*z0);
    z = p[12] + z0 * (p[13] + p[14]*z0 + p[15]*x0) + x0 * (p[16] + p[17]*x0);

    float x2 = x * m[0] + y * m[1] + z * m[2];
    float y2 = x * m[3] + y * m[4] + z * m[5];
    float z2 = x * m[6] + y * m[7] + z * m[8];
        
    avg_x = lerp(avg_x, x2, 0.999f);
    avg_y = lerp(avg_y, y2, 0.999f);
    avg_z = lerp(avg_z, z2, 0.999f);

    // re-gen params, if unstable
    float lsqr = x*x + y*y + z*z;
    if (lsqr < 0.0001f || lsqr > 100)
      gen_params();

    int sz = round(128 + 128 * z);
    int sx = round(screen_w/2 + offset_x + 500000 * (x2-avg_x) / (z2-avg_z+persp_z));
    int sy = round(screen_h/2 + offset_y + 500000 * (y2-avg_y) / (z2-avg_z+persp_z));
    if (sx >= 0 && sx < screen_w && sy >= 0 && sy < screen_h)
    {
      int i = sy * screen_w + sx;
      int c0 = color(col_r, col_g, col_b);
      pg.pixels[i] = clerp(pg.pixels[i], 255, c0, 15);
      pix++;
    }
  }
  pg.endDraw();
  
  if (pix < max_it/3)
    gen_params();
  
  // draw
//  background(0);
//  image(img, 0, 0);
 // image(img, mouseX-60, mouseY-60);
  image(pg, 0, 0);
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "Planearium" });
  }
}
