## buildings.vert

uniform vec3 lightPos;
varying float intensity;
varying vec2 windowRefl;

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;

	vec3 ecPos = vec3( gl_ModelViewMatrix * gl_Vertex );
	vec3 tnorm = normalize( gl_NormalMatrix * gl_Normal );
	vec3 lightVec = normalize( lightPos - ecPos );
	vec3 reflectVec = reflect( -lightVec, tnorm );
	vec3 viewVec = normalize( -ecPos );
	
	float diffuse = max( dot( lightVec, tnorm ), 0.0 );
	intensity = min( diffuse, 1.0 );
	
	float m;
	vec3 r, u;
	u = -viewVec;
	r = reflect( u, tnorm );
	m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z + 1.0 ) );
	windowRefl = vec2( r.x / m + 0.5, r.y / m + 0.5 );
	}

## buildings.frag

uniform sampler2D mainTex;
uniform sampler2D envTex;

varying float intensity;
varying vec2 windowRefl;

void main()
	{
	vec4 texColor = texture2D( mainTex, gl_TexCoord[0].xy );
	vec4 color = vec4( vec3( texColor.r * intensity ), 1.0 );
	if ( texColor.g > 0.1 )
		{
		color += vec4( vec3( texColor.g * texture2D( envTex, windowRefl ) ), 0.0 );
		color = min( color, vec4( 1.0 ) );
		}
	gl_FragColor = color;
	}