texture g_txSrcColor;
texture g_txSrcNormal;
texture g_txSrcPosition;
texture g_txSrcVelocity;

texture g_txSceneColor;
texture g_txSceneNormal;
texture g_txScenePosition;
texture g_txSceneVelocity;

sampler2D g_samSrcColor = sampler_state {
	Texture 	= <g_txSrcColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcNormal = sampler_state {
	Texture 	= <g_txSrcNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcPosition = sampler_state {
	Texture 	= <g_txSrcPosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcVelocity = sampler_state {
	Texture 	= <g_txSrcVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

sampler2D g_samSceneColor = sampler_state {
	Texture 	= <g_txSceneColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneNormal = sampler_state {
	Texture 	= <g_txSceneNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samScenePosition = sampler_state {
	Texture 	= <g_txScenePosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneVelocity = sampler_state {
	Texture 	= <g_txSceneVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

float4 FocalPlane = float4( 0.0f, 0.0f, 0.2f, -0.6f );

float2 PixelCoordsDownFilter[16] = {
  { 1.5,  -1.5 },
  { 1.5,  -0.5 },
  { 1.5,   0.5 },
  { 1.5,   1.5 },

  { 0.5,  -1.5 },
  { 0.5,  -0.5 },
  { 0.5,   0.5 },
  { 0.5,   1.5 },

  {-0.5,  -1.5 },
  {-0.5,  -0.5 },
  {-0.5,   0.5 },
  {-0.5,   1.5 },

  {-1.5,  -1.5 },
  {-1.5,  -0.5 },
  {-1.5,   0.5 },
  {-1.5,   1.5 },
};

float2 TexelCoordsDownFilter[16] <
	string ConvertPixelsToTexels = "PixelCoordsDownFilter";
>;

void DofCombine( float2 Tex : TEXCOORD0,
                 float2 Tex2 : TEXCOORD1,
                 out float4 oCol : COLOR0 ) {
    float3 ColorOrig = tex2D( g_samSceneColor, Tex2 );

    float3 ColorBlur = tex2D( g_samSrcColor, Tex );

    float Blur = dot( tex2D( g_samSrcPosition, Tex ), FocalPlane );

    oCol = float4( lerp( ColorOrig, ColorBlur, saturate(abs(Blur)) ), 1.0f );
}

technique PostProcess <
  string Parameter0 = "FocalPlane";
  float4 Parameter0Def = float4( 0.0f, 0.0f, 0.2f, -0.6f );
  int Parameter0Size = 4;
  string Parameter0Desc = " (vector of 4 floats)";
> {
  pass p0 {
    VertexShader 	= null;
    PixelShader 	= compile ps_2_0 DofCombine();
    ZEnable 			= false;
  }
}
