// transform object vertices to world-space:
float4x4 gWorldXf : World;

// transform object normals, tangents, & binormals to world-space:
float4x4 gWorldITXf : WorldInverseTranspose;

// transform object vertices to view space and project them in perspective:
float4x4 gWvpXf : WorldViewProjection;

// provide tranform from "view" or "eye" coords back to world-space:
float4x4 gViewIXf : ViewInverse;

texture diffuse : DiffuseMap;

sampler2D diffuseTexture = sampler_state {
    Texture = <diffuse>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

void PassThrough( float4 Pos : POSITION,
                  float2 Tex : TEXCOORD0,
                  float4 Col : COLOR,
                  out float4 oPos : POSITION,
                  out float2 oTex : TEXCOORD0,
                  out float4 oCol : COLOR ) {    
    // Pass through
    oPos = mul(Pos,gWvpXf);
    oTex = Tex;
    oCol = Col;
}

float4 PixNoLight( 	float2 Tex : TEXCOORD0,
										float4 Col : COLOR ) : COLOR {
	float4 diffuse 	= tex2D( diffuseTexture, Tex );	
	float4 color 		= Col;
	return diffuse * color;
}

technique AlphaBlend {
	pass p0 {
		AlphaBlendEnable = true;
    SrcBlend 			= SrcAlpha;
    DestBlend 		= InvSrcAlpha;
    CullMode 			= CW;
    FillMode 			= Solid;
    FogEnable 		= False;
		VertexShader 	= compile vs_2_0 PassThrough();
		PixelShader 	= compile ps_2_0 PixNoLight();
		ZEnable 			= true;
		ZWriteEnable 	= false;
	}
}

technique AdditiveBlend {
	pass p0 {
		AlphaBlendEnable = true;
    SrcBlend 			= One;
    DestBlend 		= One;
    CullMode 			= CW;
    FillMode 			= Solid;
    FogEnable 		= False;
		VertexShader 	= compile vs_2_0 PassThrough();
		PixelShader 	= compile ps_2_0 PixNoLight();
		ZEnable 			= true;
		ZWriteEnable 	= false;
	}
}