/////////// VARIABLES
float4x4 World;
float4x4 View;
float4x4 Projection;
float4x4 WVP;
float4x4 VP;
float4x4 NormalMatrix;

float3 CameraPosition;

texture Texture;
texture DiffuseTexture;
texture ShadowMapTexture;
texture SSAOTexture;
texture DisplacementTexture;

float3 Ambient = float3(0.02,0.02,0.02);

float Light1Intensity;
float3 Light1Position;
float3 Light1Target;
float3 Light1Direction;
float3 Light1Color;
float3 Light1SpecularColor;
float Light1SpecularIntensity;
float Light1SpecularGloss;
float4x4 Light1WVP;

float Light2Intensity;
float3 Light2Position;
float3 Light2Target;
float3 Light2Direction;
float3 Light2Color;
float3 Light2SpecularColor;
float Light2SpecularIntensity;
float Light2SpecularGloss;

float FilterRadiusUV = 0.05f;
float MaxDepth = 1;
float Bias = 10;
float GeggStep;
float Time;
float NearPlane = 1;
float LightSize = 1;
//float LightFrustumWidth = 1;

//////////// SAMPLERS
sampler DiffuseTextureSampler = sampler_state
{
	Texture = <DiffuseTexture>;
	MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU  = Wrap;
    AddressV  = Wrap;
};

sampler ShadowMapSampler = sampler_state
{
	Texture = <ShadowMapTexture>;
	MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler SSAOTextureSampler = sampler_state
{
	Texture = <SSAOTexture>;
	MipFilter = Point;
    MinFilter = Point;
    MagFilter = Point;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler TextureSampler = sampler_state
{
	Texture = <Texture>;
	MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU  = Wrap;
    AddressV  = Wrap;
};

sampler DisplacementTextureSampler = sampler_state
{
	Texture = <DisplacementTexture>;
	MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
    AddressU  = Clamp;
    AddressV  = Clamp;
};


/////////// INPUTS AND OUTPUTS
struct VertexShaderInput
{    
    float4 Position : POSITION0;
    float4 Normal : NORMAL0;
    float2 TexCoord : TEXCOORD0;
	float4 Color : COLOR0;
};

struct VertexShaderOutput
{
	float4 Position : POSITION;
    float4 PositionWorld : POSITION1;
    float4 PositionScreen : POSITION2;
	
	float4 Normal : NORMAL0;
	float4 NormalEye : NORMAL1;
    
    float2 TexCoord : TEXCOORD0; 
    float4 Color : COLOR0;
    
    float3 ShadowCoord : TEXCOORD1;    
    float3 RealDistance: TEXCOORD2;
};

struct PixelShaderOutput
{
	float4 Color : COLOR0;
};

struct Light
{
	float3 Position;
	float3 Target;
	float4 Color;
	float Near;
	float Far;
	float4x4 WVP;
};

struct Material
{
	bool UseDiffuseTexture;
	float4 Diffuse;
	float4 Specular;
	float Gloss;
	float4 SelfIllumination;
	float DisplacementAmount;
	float2 DisplacementOffset;
	float2 DisplacementScale;
};

const int NumLights = 3;
Light Lights[3];

Material CurrentMaterial;


