
uniform vec4 insideColor;
uniform sampler1D outsideColorTable;
uniform float maxIterations;
uniform float counter;

void main ()
{
	maxIterations = 1000;
	insideColor = vec4(gl_FragColor.x,0,0,1);

	vec2 c = gl_TexCoord[0].xy;
	vec2 z = c;
	gl_FragColor = insideColor;

	for (float i = 0; i < maxIterations; i += 1.0)
	{
		z = vec2(z.x*z.x - z.y*z.y, 2.0*z.x*z.y) + c * 1.01;
		if (dot(z, z) > 4.0)
		{
			gl_FragColor = texture1D(outsideColorTable, 
			i / maxIterations);
			break;
		}
	}

	gl_FragColor += vec4(sin(counter),0,0,1);
}

