uniform vec3 cameraPosOS;
uniform float factor, factor3, spheriness, blobbiness;

varying vec3 posOS;

float distance(vec3 pos) {
	
	// Add noise
	vec3 spf = sin(pos*factor+factor3);
	float bla=1.0+spf.x*spf.y*spf.z*blobbiness;
	
	float d1 = length(pos)-bla;

	// Fake cube stuffy (orthogonal distance)
	vec3 dc1 = abs(pos)-vec3(bla);
	float d3 = max(max(dc1.x, dc1.y), dc1.z);
	
	return mix(d1,d3,spheriness);
}

void main() {

	vec3 pos = cameraPosOS;
	vec3 dir = normalize(posOS-cameraPosOS);

	float t=0.0;
	float d=0.0;
	
	for (int i=0; i<5; i++) {
		d = distance(pos);
		pos += dir * d;
		t+=d;
	}
	
	//float shade = sunSize/t*50.0/(1.0+d);
	//float shade = 1.0/(1.0+d*0.02);
	float shade = 6.0/t;

	shade*=shade;
	
	float alpha = smoothstep(0.01,0.05, shade);

	gl_FragColor = vec4(vec3(8.0, 6.0, 2.0)*1.5*shade, alpha);//1.0);//shade);
}
