#version 110

uniform sampler2D texDepth;
uniform sampler2D texColor;

uniform vec3 fk[32];
uniform float pTimer;

float readDepth( in vec2 coord ) {
	return abs(texture2D( texDepth, coord ).a); 
}

void main(void)
{
	float bl = 0.0;
	float rad=(1.0/1280.0)*35.0;
	
	float noise = fract(sin(pTimer+dot( gl_TexCoord[0].st ,vec2(12.9898,78.233))) * 43758.5453)*2.0-0.8;
	
	int random_offset = int(mod(noise, 16.0));
	
	vec2 pos = gl_TexCoord[0].st;
	float z = readDepth(pos);
	
	for( int i=0; i<16; i++ )
	{
		vec2 pos2 = pos + (fk[i].xy*rad/(z*0.02));
		
		float z2 = readDepth(pos2);
		
		float cap = 3.141532*.091;
		float a=clamp(z-z2, 0.0, cap);
		
		bl+=a*0.5;
	}
	
	vec3 ambientColor=vec3(0.4,0.4,0.5);
	vec3 ambient = ambientColor* texture2D(texDepth, gl_TexCoord[0].st).xyz;
	
	gl_FragColor = texture2D(texColor, gl_TexCoord[0].st) + vec4(ambient*float(1.0-bl/8.0), 0.0);
}
