attribute vec3 va_position, va_normal;

uniform mat4 mat_sun_view2uv, mat_view2world;

varying vec3 posVS, posWS, normalVS, normalWS;
varying vec4 sunUV;

void main(void)
{	
	vec3 temp_posVS    = (gl_ModelViewMatrix * vec4(va_position, 1.0)).xyz;
	vec3 temp_normalVS = gl_NormalMatrix     * va_normal;
	
	posVS    = temp_posVS;
	normalVS = temp_normalVS;
	
	posWS    = (mat_view2world  * vec4(temp_posVS,    1.0)).xyz;
	normalWS = (mat_view2world  * vec4(temp_normalVS, 0.0)).xyz;
	sunUV    =  mat_sun_view2uv * vec4(temp_posVS,    1.0);

	gl_Position = gl_ModelViewProjectionMatrix * vec4(va_position, 1.0);
	gl_FrontColor  = gl_Color;
}
