/*
 * Spiral.fx
 *
 * Created on 08.05.2009, 12:54:42
 */

package samples.mathematics.plotter;

/**
 * @author Alexandr Scherbatiy
 */

import javafx.stage.*;
import javafx.scene.*;
import javafx.scene.transform.*;
import mathematics.multidimensional.dim1.*;
import mathematics.multidimensional.dim3.*;
import mathematics.multidimensional.shape.*;
import javafx.util.Math;


var r = 30.0;


Stage {
    title: "Spiral"
    scene: Scene {
        width: 300
        height: 300
        content: [
            MDUniversePlayer{
                dimension: 3
                autoplay: true
                transforms: Transform.translate(150,150);
                shapes: MDPlotter{

                    mdtransform: CurveDim3{
                        x: function(tau:Number):Number{ r *  Math.cos(Math.toRadians(tau)) }
                        y: function(tau:Number):Number{ r *  Math.sin(Math.toRadians(tau)) }
                        z: function(tau:Number):Number{ tau / 10 }
                    }

                    domain: ParametrizedSetDim1{
                        startPoint: -450
                        endPoint:    450
                        delta:     12.0
                    }

                }
            }
        ]
    }
}
