/*
 * HyperbolicParaboloid.fx
 *
 * Created on May 18, 2009, 2:12:20 PM
 */

package samples.mathematics.plotter;


/**
 * @author Alexandr Scherbatiy
 */

import javafx.stage.*;
import javafx.scene.*;
import javafx.scene.transform.*;
import mathematics.multidimensional.dim2.*;
import mathematics.multidimensional.dim3.*;
import mathematics.multidimensional.shape.*;


Stage {
    title: "Hyperbolic Paraboloid"
    scene: Scene {
        width: 200
        height: 200
        content: [
            MDUniversePlayer{
                time: 20s
                dimension: 3
                autoplay: true
                transforms: Transform.translate(100,100);

                shapes: MDPlotter{
                    mdtransform: SurfaceDim3 {
                        z: function(u:Number, v:Number):Number{ (u * u - v * v) / 100.0 } 
                    }
                    domain: ParametrizedSetDim2{
                        delta: 15.0
                        startPointX: -75
                        startPointY: -75
                        endPointX: 75
                        endPointY: 75
                    }
                }
            }
        ]
    }
}