/*
 * Main.fx
 *
 * Created on 01.08.2009, 17:35:55
 */

package samples.mathematics.graph;


import mathematics.graph.*;
import javafx.stage.Stage;
import javafx.scene.Scene;

/**
 * @author Alexandr Scherbatiy
 */


var graph = Graph{
        order: 5
        connections: [
            Connection{ vertex1: 0 vertex2: 1 }
            Connection{ vertex1: 0 vertex2: 2 }
            Connection{ vertex1: 0 vertex2: 3 }
            Connection{ vertex1: 1 vertex2: 2 }
            Connection{ vertex1: 3 vertex2: 4 }
        ]
};


var shortestPath:Edge[];

Stage {
    title : "Graph - Shortes Path"
    scene: Scene {
        width: 300
        height: 300
        content: [
            GraphView{
                translateX: 150
                translateY: 150
                graph: graph
                selectedEdges: bind shortestPath
                
                onSelectionChanged:function(source:Vertex, destination:Vertex){
                    shortestPath = GraphAlgorithm.dijkstraShortestPath(source, destination, graph);
                }

            }

        ]
    }
}



