/*
 * CelestialBodySystem.fx
 *
 * Created on 07.05.2009, 19:07:15
 */

package physics.newton;

/**
 * @author Alexandr Scherbatiy
 */

import javafx.util.Math;


import javafx.scene.*;
import javafx.scene.shape.*;
import javafx.scene.text.*;
import javafx.scene.paint.*;


//import mathematics.multidimensional.dim3.*;

function square(x: Number): Number{
    return x * x;
}


class Scale{
    package var radiusScale: Number;
    package var coordinateScale: Number;
}

public class BodySystem extends CustomNode{
    public var dimension: Integer = 2;
    public var dt: Number = 60* 60 * 24 * 2;
    public var G: Number = 6.67e-11;
    public var bodies:  Body[];

    package var scale: Scale = Scale{coordinateScale:  100.0/150e9 radiusScale: 20.0/14000.0};

  public function run():Void{

    for(p1 in bodies){

//        for(i in [0..dimension-1]){
//            p1.acceleration[i] = 0.0;
//        }

        p1.acceleration.zero();

        for(p2 in bodies[p| p!=p1]){

            var k = G * p2.mass;

            var deltaR = p2.coordinate.sub(p1.coordinate);

//            for(i in [0..dimension-1]){
//                deltaR[i] = p2.coordinate[i] - p1.coordinate[i];
//            }



            var squareR = deltaR.square();
//            for(i in [0..dimension-1]){
//                squareR += square(deltaR[i]);
//            }

            p1.acceleration = p1.acceleration.add(deltaR.mul(k / (squareR * Math.sqrt(squareR))))
//            for(i in [0..dimension-1]){
//                p1.acceleration[i] += k * deltaR[i] / (squareR * Math.sqrt(squareR));
//            }

        }

    }

    for(p in bodies){
        //for(i in [0..dimension-1]){
            p.velocity   = p.velocity.add( p.acceleration.mul( dt) );
            p.coordinate = p.coordinate.add( p.velocity.mul( dt ));
        //}
    }
  }


    override function create():Node{
      Group{
        content: [
         Group{
            content: for(i in  [1..15])
            Circle{
                centerX: Math.random() * 300 - 150
                centerY: Math.random() * 300 - 150
                radius: 2
                fill: Color.WHITE
            }
         },
          Group{
            content: bind for(planet in bodies)
            Group{
                content: [
                Circle{
                    centerX: bind planet.coordinate.elems[0] * scale.coordinateScale
                    centerY: bind planet.coordinate.elems[1] * scale.coordinateScale
                    radius: planet.radius * scale.radiusScale
                    fill: planet.color
                },
                Text{
                    content: planet.name
                    font: Font {name: "BOLD" size: 16}
                    x: bind planet.coordinate.elems[0] * scale.coordinateScale + 15
                    y: bind planet.coordinate.elems[1] * scale.coordinateScale - 15
                    strokeWidth: 3
                    fill: Color.WHITE
                }
                ]
            }
        }]

    };
  }
}
