/*
 * ElectroScheme.fx
 *
 * Created on Aug 6, 2009, 5:45:11 PM
 */

package physics.electronic;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;

import javafx.scene.CustomNode;

import javafx.scene.Group;


//  ============  ElectroScheme  ====================//

public class ElectroScheme extends CustomNode{
    
    public var wires: Wire[];

    public var components: ElectronicComponent[];

    public function simulate(){
      for(comp in [ components, wires ]){
        comp.simulate();
      }
    }

    override function create() {
        Group{
            content: [ wires, components ]
        }
    }

    postinit{
        Timeline {
            repeatCount: Timeline.INDEFINITE
            keyFrames:  KeyFrame {
                time: 20ms
                action: function() { simulate(); }
            }
        }.play();        
    }

}
