/*
 * MDUiverseView.fx
 *
 * Created on 08.05.2009, 19:33:58
 */

package mathematics.multidimensional.shape;
import mathematics.multidimensional.*;
import mathematics.multidimensional.shape.MDUniverse;
import javafx.scene.input.*;
import javafx.animation.*;

/**
 * @author Alexandr Scherbatiy
 */

public class MDUniversePlayer extends MDUniverse{

    public var time:Duration = 50ms; //10s;
    public var autoplay: Boolean = false;

    //var angle:Number;

    var angleXY: Number;
    var angleXZ: Number;
    var angleYZ: Number = 90;

    var deltaAngle:Number = 1.0;

    var pause:Boolean;

    override var timeTransforms = bind for(n in [0..dimension-1])for(m in [0..n-1]){
                MDRotate{
                    dim: dimension
                    axisM: m
                    axisN: n
                    angle: deltaAngle
                }
            }
//    override var timeTransforms =
//                MDRotate{
//                    dim: dimension
//                    axisM: 0
//                    axisN: 1
//                    angle: 3
//                }
//
//    


//    override var mdtransforms = bind if (not autoplay) [
//                MDRotate{
//                    dim: 3
//                    axisM: 0
//                    axisN: 1
//                    angle: angleXY
//                }
//                MDRotate{
//                    dim: 3
//                    axisM: 0
//                    axisN: 2
//                    angle: angleXZ
//                }
//                MDRotate{
//                    dim: 3
//                    axisM: 1
//                    axisN: 2
//                    angle: angleYZ
//                }
//            ] else rotateTransforms;

    //override var timeTransforms = rotateTransforms;


//            function getRotateTransforms(angle:Number){
//                for(t in rotateTransforms){
//                    t.angle = angle;
//                }
//                return rotateTransforms;
//            }


//    override var onKeyTyped = function( e: KeyEvent ):Void {
//        println("key typed: {e.char}");
//        println("key typed: {e.code}");
//    }

    override var onKeyPressed = function( e: KeyEvent ):Void {
        //println("key pressed: {e.char}");
        println("key pressed: {e.code}");
        var delta = deltaAngle;

        if(e.code == KeyCode.VK_RIGHT){
            angleXY += delta;
        }else if(e.code == KeyCode.VK_LEFT){
            angleXY -= delta;
        }else if(e.code == KeyCode.VK_UP){
            angleYZ -= delta;
        }else if(e.code == KeyCode.VK_DOWN){
            angleYZ += delta;
        }else if(e.code == KeyCode.VK_COMMA){
            angleXZ -= delta;
        }else if(e.code == KeyCode.VK_PERIOD){
            angleXZ += delta;
        }else if(e.code == KeyCode.VK_P){
            //println("pause: {pause}");
            pause = not pause;

            if(pause){
                timeline.pause();
            }else{
                timeline.play();
            }

        }



    }


    var timeline:Timeline =  Timeline {
                repeatCount: Timeline.INDEFINITE
                keyFrames: [
                    KeyFrame {
                        time: time
                        canSkip: true
                        action: function(){
                            evolve();
                        }

                    }
                ]
            };


    init{

        //println("[md universe player] init");

        

        if(autoplay){
            timeline.play();
        }
        


    }


}
