package mathematics.multidimensional.shape;

/**
 * @author Alexandr Scherbatiy
 */


import mathematics.multidimensional.*;

import mathematics.multidimensional.ICMDVector;

import javafx.util.Math;



public class MDPoint extends MDShape, AMDVector{


    public var elems: Number[];


    public var x:Number;
    public var y:Number;

    public var evolved:IMDVector;
    
    
    public var metric:IMDSquareTransform = MDIdentity{ dim: dim };


//    public var cashed:Boolean = false;

    override function getDim(){ dim };

    override function getElem(n: Integer):Number{ elems[n] }

    public override function getMetric(){ metric }


    override function getPoints (): MDPoint[] { this }

    override function getCVector():ICMDVector{
        MDVector.getCVector(this)
    }

    public function reset(){
        evolved = this;
        //println("Reset: {evolved}");
    }

    public function evolve(transform:IMDTransform, projection:IMDTransform){
            //println("[evolve] before: {evolved}");
            evolved = transform.transform(evolved);
            var project = projection.transform(evolved);
            //println("[evolve] after: {evolved}");
            //println("");
            x = project.getElem(0);
            y = project.getElem(1);
    }

    override function equals (obj:Object):Boolean{

            var eps = 0.0001;

            if(obj instanceof MDPoint){
                var point = obj as MDPoint;
                
                if(dim != point.dim){
                    return false;
                }

                for(n in [0..dim-1]){
                    if(eps < Math.abs(elems[n] - point.elems[n]))  {
                        return false;
                    }
                }
                return true;
            }

            return false;
    }

//    public override function toString():String {
//          "cashed: {cashed}, {super.toString()}"
//          //"cashed: {cashed}, {AMDVector.toString()}"
//    }

}

public function createPoint(vector:IMDVector):MDPoint{
    MDPoint{
        dim: vector.getDim()
        elems: MDVector.getElems(vector)
    }
}
