/*
 * CurveDim3.fx
 *
 * Created on 08.05.2009, 12:37:14
 */

package mathematics.multidimensional.dim3;

import mathematics.multidimensional.AMDTransform;
import mathematics.multidimensional.IMDVector;
import mathematics.multidimensional.MDVector;

/**
 * @author Alexander Scherbatiy
 */




public class SurfaceDim3 extends AMDTransform{

    override var dimM = 2;
    override var dimN = 3;


    public var x: function(u:Number, v:Number):Number = function(u:Number,v:Number){u};
    public var y: function(u:Number, v:Number):Number = function(u:Number,v:Number){v};
    public var z: function(u:Number, v:Number):Number = function(u:Number,v:Number){0};

    public override function transform (vector:IMDVector):IMDVector {
        var u = vector.getElem( 0 );
        var v = vector.getElem( 1 );

        MDVector{
            dim: 3
            elems: [ x(u,v),  y(u,v), z(u,v)   ]
        }
    }


}
