/*
 * CurveDim3.fx
 *
 * Created on 08.05.2009, 12:37:14
 */

package mathematics.multidimensional.dim3;

import mathematics.multidimensional.AMDTransform;
import mathematics.multidimensional.IMDVector;
import mathematics.multidimensional.MDVector;

/**
 * @author Alexander Scherbatiy
 */


function zero(tau:Number):Number { 0 }
//function identity(tau:Number):Number { tau }


public class CurveDim3 extends AMDTransform{

    override var dimN = 1;
    override var dimM = 3;


    public var x: function(tau:Number):Number = zero;
    public var y: function(tau:Number):Number = zero;
    public var z: function(tau:Number):Number = zero;




    public override function transform (vector:IMDVector):IMDVector {
        var tau = vector.getElem( 0 );

        MDVector{
            dim: 3
            elems: [ x(tau),  y(tau), z(tau)   ]
        }
    }


}
