package mathematics.multidimensional;


import javafx.util.Math; 
 
public class MDRotate extends AMDSquareMatrix{
    
    public var angle:Number;
    
    public var axisN:Integer ;
    public var axisM:Integer ;
    
    
    //override function getDim ():Integer { dim };

    var radians:Number;
    
    var cos:Number;
    var sin:Number;

    override function getElem(n:Integer, m:Integer) {
            
        if(n == axisN and m == axisN){
            cos
        }else if (n == axisN and m == axisM){
            sin
        }else if (m == axisN and n == axisM){
            -sin
        }else if (m == axisM and n == axisM){
            cos
        }else{
            0
        }

    }


    override function transform (vector:IMDVector):IMDVector {
        
        var radians = Math.toRadians(angle);

        var cos = Math.cos(radians);
        var sin = Math.sin(radians);
        
        var elemN = vector.getElem(axisN);
        var elemM = vector.getElem(axisM);

        MDVector{
            dim: dim
            elems: for( i in [0..dim-1]){
                    if(i == axisN){
                        (cos * elemN + sin * elemM)
                    }else if(i == axisM){
                        (- sin * elemN + cos * elemM)
                    }else{
                        vector.getElem(i)
                    }
                }
        };

        
    } 

    init{
        radians = Math.toRadians(angle);

        cos = Math.cos(radians);
        sin = Math.sin(radians);
        
    }


    override function toString ():String { "MDRotate\{ dim: {dim}, angle: {angle} axes: {axisN}, {axisM} \}"  }

}