/*
 * MDParametrizedSet.fx
 *
 * Created on 05.05.2009, 21:27:44
 */

package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */

public class MDParametrizedSet extends MDSet{

    public var dim:Integer;

    public var start:IMDVector;
    public var end:IMDVector;

    public var delta:Number;

    public override function getVectors():IMDVector[]{
//        for(n in []){
//            MDVector{}
//        }

        var vectors:IMDVector[];

        var start0 = start.getElem(0);

        var end0 = end.getElem(0);

        var x0 = start0;

        if(dim == 1){
            while(x0 < end0){
                insert MDVector{ dim: dim elems: [ x0 ]  } into vectors;
                x0 += delta;
            }
        } else {
            var start1 = start.getElem(1);
            var end1 = end.getElem(1);

            while(x0 < end0){
                var x1 = start1;
                while(x1 < end1){
                insert MDVector{ dim: dim elems: [ x0, x1]  } into vectors;
                    x1 += delta;
                }
                x0 += delta;
            }

        }

//        for(vector in vectors) {
//            println("[set] {vector}");
//        }

        return vectors;
    }


}
