/*
 * MDSquareTransform.fx
 *
 * Created on 05.05.2009, 20:47:40
 */

package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */

public mixin class AMDSquareTransform extends AMDTransform, IMDSquareTransform {

     public var dim: Integer;

     override function getDim ():Integer { dim }
     

     override function getDimN ():Integer { dim }
     override function getDimM ():Integer { dim }


     public override function mul(transform:IMDSquareTransform):IMDSquareTransform{
        var  T1 = transform;
        var  T2 = this;

        AMDSquareTransform{
            dim: dim

            public override function transform(vector: IMDVector):IMDVector{
                T2.transform(T1.transform(vector));
            }

        }


     }

     init{
         dimN = dim;
         dimM = dim;
     }



}

