/*
 * AMDMatrix.fx
 *
 * Created on Jul 31, 2009, 1:37:42 PM
 */

package mathematics.multidimensional;

import mathematics.multidimensional.MDMatrix;

/**
 * @author andromeda
 */

public mixin class AMDMatrix extends AMDTransform, IMDMatrix{
        


    override function transform (vector:IMDVector):IMDVector {
        return mul(vector);
    }


    override function mul (vector:IMDVector):IMDVector {

        MDVector{
            dim: dimN
            elems: for( n in [0 ..dimN - 1]){
                var elem = 0.0;
                for( m in [0..dimM - 1]){
                    elem += getElem ( n, m ) * vector.getElem(m);
                }
                elem
            }


        }

    }

    function mul (matrix:IMDMatrix):IMDMatrix {
            MDMatrix.mul(this, matrix);
    }


    override function drop(n:Integer, m:Integer):IMDMatrix{
        MDMatrix{
            dimN: dimN - 1
            dimM: dimM - 1
            elems: for(i in [[0..n-1], [n+1..dimN-1]]){
                        for(j in [[0..m-1], [m+1..dimM-1]]){
                                getElem(i, j);
                        }
                    }

        }

    }

    override function getRow(n:Integer):IMDVector{
            MDMatrix.getRow(n, this)
//            MDVector{
//                dim: getDimM()
//                elems: for(m in [0..dimM-1])  getElem(n, m)
//            }
    }

    override function getColumn(m:Integer):IMDVector{
            MDMatrix.getColumn(m, this)
//            MDVector{
//                dim: getDimN()
//                elems: for(n in [0..dimN-1])  getElem(n, m)
//            }
    }


    override function getCMatrix():ICMDMatrix {
        MDMatrix.getCMatrix(this);
    }


    override function toString():String {
        "Matrix\{ dim: {dimN} x {dimM} elems: {for(n in [0..dimN-1]) "[ {for(m in [0..dimM-1]) "{getElem(n,m)} "}]" } \}"
    }
}

