/*
 * LinearEquationSystem.fx
 *
 * Created on Aug 4, 2009, 5:27:32 PM
 */

package mathematics.equation;

import mathematics.multidimensional.MDSquareMatrix;

import mathematics.multidimensional.MDVector;

/**
 * @author andromeda
 */

public class LinearEquationSystem {

    public var equations:LinearEquation[];

    public function solve():Void{
        var dim = sizeof equations[0].coefficients;

        for(n in [1..sizeof equations-1]){
            if(dim!=  sizeof equations[n].coefficients){
                   println("Equations have different size!!!");
                   return;
            }
        }

        var matrix = MDSquareMatrix{
            dim: dim
            elems: for(equation in equations) equation.coefficients
        }

        //println(matrix);
        var determinat = matrix.determinant();

        if(determinat == 0){
            println("determinat is zero!");
            return;
        }

        //println("determinat: {determinat}");

        var right = MDVector{
            dim: dim
            elems: for(n in [0..<dim]) equations[n].solution
        }

        //println("right: {right}");

        solutions = for(n in [0..<dim]){
            var m = matrix.getCSquareMatrix();
            m.setColumn(n, right);
            m.determinant() / determinat;
        }


    }

    public-read var solutions:Number[];
   

    public override function toString():String {
        "{for(equation in equations) "{equation}\n"}"
        "{for(solution in solutions) "x{indexof solution + 1} = {solution}, "}"
    }
}
