package express.demo;

import javafx.animation.Timeline;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;
import java.lang.Math;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.Media;

var rot: Double = 0.0;
var irad: Double = 1.0;

MediaPlayer { 
    media: Media { source: "{__DIR__}music.mp3" }
}.play();

Timeline {
    repeatCount: Timeline.INDEFINITE
    keyFrames: [
        at(0s) {rot => 0.0},
        at(5s) {rot => 2.0 * Math.PI}
    ]
}.playFromStart();

Timeline {
    repeatCount: Timeline.INDEFINITE
    autoReverse: true
    keyFrames: [
        at( 0.0s) {irad => 6.00},
        at( 4.5s) {irad => 0.30},
        at(10.5s) {irad => 0.10},
        at(16.5s) {irad => 0.05},
    ]
}.playFromStart();

Stage {
    title: "Express JavaFX demo by Eustas"
    scene: Scene {
        width: 512, height: 512
        fill: bind RadialGradient {
            centerX: 256
            centerY: 256
            radius: Math.exp(irad)
            focusX: 256 + Math.cos(rot)
            focusY: 256 + Math.sin(rot)
            proportional: false
            cycleMethod: CycleMethod.REFLECT
            stops: [
                Stop {offset: 0.000, color: Color.hsb(  0,1.0,1.0)},
                Stop {offset: 0.250, color: Color.hsb( 90,1.0,1.0)},
                Stop {offset: 0.500, color: Color.hsb(180,1.0,1.0)},
                Stop {offset: 0.750, color: Color.hsb(270,1.0,1.0)}
            ]
        }
    }
}