struct PS_INPUT
{
  float2 Tex0: TEXCOORD0;
};

sampler base_map = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_InvScreenW : INVSCREENW;
float V_InvScreenH : INVSCREENH;
float V_Var14: VAR14; // Layer alpha
float V_Var15: VAR15; // Blur offset

float4 PS(PS_INPUT In) : COLOR0
{
  float4 color;
  color = tex2D(base_map, In.Tex0 + float2(0, V_InvScreenH * V_Var15));
  color+= tex2D(base_map, In.Tex0 + float2(0,-V_InvScreenH * V_Var15));
  color+= tex2D(base_map, In.Tex0 + float2( V_InvScreenW * V_Var15,0));
  color+= tex2D(base_map, In.Tex0 + float2(-V_InvScreenW * V_Var15,0));
  //return (color * 0.25 * V_Var14) + (tex2D(base_map, In.Tex0) * (1-V_Var14));
  color = color * 0.25;
  color.a = V_Var14;
  return color;
}

technique Blur
{
  pass Blur
  {
    PixelShader = compile ps_2_0 PS();
  }
}
