//-----------------------------------------------------------------------------
//
struct VS_OUTPUT
{
  float4 Pos: POSITION;
  float2 Tex0:     TEXCOORD0;
};


//-----------------------------------------------------------------------------
//
float V_Time          : TIME;
float V_ColorScale_R  : VAR1;
float V_ColorScale_G  : VAR2;
float V_ColorScale_B  : VAR3;
float V_ColorOffset_R : VAR4;
float V_ColorOffset_G : VAR5;
float V_ColorOffset_B : VAR6;
float V_SpecPow       : VAR7;
float V_TimeScale     : VAR8;
float V_Rand1 	      : RAND1;

//-----------------------------------------------------------------------------
//dummy VS_3_0 shader
VS_OUTPUT VS(float4 Position: POSITION,float4 TexCoord: TEXCOORD0)
{
  VS_OUTPUT OUT = (VS_OUTPUT)0;

  OUT.Pos       = Position;
  OUT.Tex0      = TexCoord.xy;

  return OUT;
}


//-----------------------------------------------------------------------------
//true amphobull
float4 PS(VS_OUTPUT In) : COLOR0
{
  
  float V_SpecPowTr = V_SpecPow;
  V_SpecPowTr = V_SpecPowTr + V_SpecPowTr*0.5*V_Rand1;
  if (V_SpecPowTr<0.01) V_SpecPowTr = 0.01;

  
  
  float fTime2 = V_Time*(1 + V_TimeScale*10); 
  //const float fTime2 = V_Time*(1 + V_TimeScale*10); 

  float2 vCenter1 = In.Tex0 - float2(sin(fTime2/3),cos(fTime2/5));
  float2 vCenter2 = In.Tex0 - float2(sin(fTime2/4),cos(fTime2/6));

  float fPlazma = (sin(In.Tex0.x*5 + 3*cos(fTime2/10))*sin(dot(vCenter1,vCenter1)) + 
                   cos(In.Tex0.y*4 + 2*sin(fTime2/8))*cos(dot(vCenter2,vCenter2)) +
                   sin((In.Tex0.x*3 + In.Tex0.y*2)*sin(fTime2/10))*sin(dot(vCenter2,vCenter2))*cos(dot(vCenter1,vCenter1))*2)/3;

  float fSpec = pow(fPlazma + .3,V_SpecPowTr*10);

  half4 c;
  c.x   = 0.5 + 0.5*sin(fPlazma*V_ColorScale_R*10 + V_ColorOffset_R + fTime2/4);
  c.y   = 0.5 + 0.5*sin(fPlazma*V_ColorScale_G*10 + V_ColorOffset_G + fTime2/6);
  c.z   = 0.5 + 0.5*sin(fPlazma*V_ColorScale_B*10 + V_ColorOffset_B + fTime2/7);
  c.xyz += fSpec;
  c.w   = 1;

  return c;
}


//-----------------------------------------------------------------------------
//
technique AmphoBull
{
  pass PassPlazma
  {
    VertexShader = compile vs_3_0 VS();
    PixelShader  = compile ps_3_0 PS();
  }
}
