varying vec3 vcoord;

void main()
{
	const float pi = 3.141576;
	const float d2r1 = (128.0 / pi);
	const float d2r2 = (32.0 / pi);

	vec4 v = vec4(gl_Vertex);

	float a1 = (2.0 * v.y) / d2r1;
	float a2 = (2.0 * v.x) / d2r2;

	v.x = (32.0 + 16.0 * cos(a2)) * cos(a1);
	v.y = (32.0 + 16.0 * cos(a2)) * sin(a1);
	v.z = 16.0 * sin(a2);

	

	gl_Position = gl_ModelViewProjectionMatrix * v;
	vcoord = vec3(v);
}
