uniform float ptimer;
uniform sampler2D tex;
varying vec3 coord;

void main()
{
	vec2 tc = gl_TexCoord[0].st;

	tc.s = tc.s + sin((82.0*coord.x + ptimer) / 412.0) * 0.0025 + sin((64.0*coord.x + ptimer) / 312.0) * 0.0075 + sin((120.0*coord.y + ptimer) / 256.0) * 0.005 + sin((64.0*coord.y + ptimer) / 384.0) * 0.0025;
	tc.t = tc.t + sin((64.0*coord.x + 48.0*coord.y + ptimer) / 256.0) * 0.2 + sin((96.0*coord.x + 32.0*coord.y + ptimer) / 224.0) * 0.15;

	vec4 color = texture2D(tex,tc);

	color.r = color.r * 0.75;
	color.g = color.g * 0.75;
	color.b = color.b * 0.75;

	gl_FragColor = color;
}
