uniform float fcmul;
uniform float px, py;
uniform float vmul;

uniform sampler2D tex;
varying vec3 coord;

void main()
{
	vec2 tc = gl_TexCoord[0].st;

	float x = coord.x / 2.0 + px;
	float y = -coord.y + py;

	float cdis = sqrt(x * x + y * y);

	vec2 rbv = vec2(0.0, 0.0);
	if (cdis!=0.0)
	{
		rbv.x = (x / cdis) * vmul;
		rbv.y = (y / cdis) * vmul;
	}

	const float n = 16.0;
	vec4 finalcolor = vec4(0.0, 0.0, 0.0, 0.0);

	for (float i=0.0; i<n; i++)
	{
		tc.s = tc.s + i * rbv.x;
		tc.t = tc.t + i * rbv.y;

		vec4 color = texture2D(tex,tc);

		finalcolor.r = finalcolor.r + color.r;
		finalcolor.g = finalcolor.g + color.g;
		finalcolor.b = finalcolor.b + color.b;
		finalcolor.a = finalcolor.a + color.a;
	}

	finalcolor.r = (finalcolor.r / n) * fcmul;
	finalcolor.g = (finalcolor.g / n) * fcmul;
	finalcolor.b = (finalcolor.b / n) * fcmul;
	finalcolor.a = (finalcolor.a / n) * fcmul;

	gl_FragColor = finalcolor;
}
