varying vec3 coord;
uniform float ptimer;

void main()
{
	float x = coord.x;
	float y = coord.y;
	float z = coord.z;

	float c = (y + 256.0) / 448.0;
	if (c < 0.0) c = 0.0;

	float r = c / 2.0;
	float g = c / 1.5;
	float b = 0.05 + c * 0.95;
	float a = 1.5*c;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
