uniform float lx, ly, lz;
uniform float rmul, gmul, bmul;

uniform sampler2D tex;

void main()
{
	vec2 tc = gl_TexCoord[0].st;

	float vx, vy, vz, va;
	float lc, phong, fl;

	vec4 tp = texture2D(tex,tc);

	vx = (tp.r - 0.5) * 2.0;
	vy = (tp.g - 0.5) * 2.0;
	vz = tp.b * 2.0;
	va = tp.a;

	const float phmul = 0.25;
	const float nphmul = 0.75;
	const float phlim = 64.0 * phmul;

	lc = (vx*lx + vy*ly + vz*lz);

	phong = 0.25 / ((vx - lx) * (vx - lx) + (vy - ly) * (vy - ly) + (vz - lz) * (vz - lz));
	if (phong > phlim) phong = phlim;
	fl = (nphmul * lc + phmul * phong) * va;

	vec4 color = vec4(rmul * fl, gmul * fl, bmul * fl, va);


	gl_FragColor = color;
}
