
varying vec2 texcoord;
varying vec2 texcoordmul;

uniform sampler2D seedTex;
uniform sampler2D extratex;
uniform float time;

/*float noiseval(vec2 xy, float t) {
	vec2 coord = xy;
	coord.x += xy.x + xy.y + xy.x*xy.y*0.001 + xy.x*t + xy.y*t + (xy.x*xy.y+t);
	coord.y += xy.x + xy.y + xy.x*xy.y*0.001 + xy.x*t + xy.y*t + (xy.x*xy.y+t);
	return texture2D(seedTex, coord).r;
}*/

vec3 noiset(vec3 xyz) {
	return texture2D(seedTex, vec2(xyz.x+xyz.z, xyz.y+xyz.z)).rgb;
}

float noiseval(vec2 coord, float newTime) {
	const float octave = 30.0;
	return noiset(vec3(coord*octave*0.0078125, 1.0*newTime*0.078125)).r*128.0+
	       noiset(vec3(coord*octave*0.015625,  1.0*newTime*0.015625)).r*64.0+
	       noiset(vec3(coord*octave*0.03125,   1.0*newTime*0.03125)).r*32.0+
	       noiset(vec3(coord*octave*0.0625,    1.0*newTime*0.0625)).r*16.0+
	       noiset(vec3(coord*octave*0.125,     1.0*newTime*0.125)).r*8.0+
	       noiset(vec3(coord*octave*0.25,      1.0*newTime*0.25)).r*4.0+
	       noiset(vec3(coord*octave*0.5,       1.0*newTime*0.5)).r*2.0+
	       noiset(vec3(coord*octave,           1.0*newTime)).r;
}

void main() {
	const float texscale = 1.0;

	vec2 texcoord = gl_TexCoord[0].xy*texscale;

	// fofoo
	vec4 add = texture2D(extratex, gl_TexCoord[0].xy);

	gl_FragColor = (vec4(noiseval(texcoord, time*0.05))/(255.0)) - add*4.0;
}
