texture g_txSrcColor;
texture g_txSrcNormal;
texture g_txSrcPosition;
texture g_txSrcVelocity;

texture g_txSceneColor;
texture g_txSceneNormal;
texture g_txScenePosition;
texture g_txSceneVelocity;

sampler2D g_samSrcColor = sampler_state {
	Texture 	= <g_txSrcColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcNormal = sampler_state {
	Texture 	= <g_txSrcNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcPosition = sampler_state {
	Texture 	= <g_txSrcPosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcVelocity = sampler_state {
	Texture 	= <g_txSrcVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

sampler2D g_samSceneColor = sampler_state {
	Texture 	= <g_txSceneColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneNormal = sampler_state {
	Texture 	= <g_txSceneNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samScenePosition = sampler_state {
	Texture 	= <g_txScenePosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneVelocity = sampler_state {
	Texture 	= <g_txSceneVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

float4 Combine( float2 Tex : TEXCOORD0,
                float2 Tex2 : TEXCOORD1 ) : COLOR0 {
  float3 ColorOrig = tex2D( g_samSceneColor, Tex2 );

  ColorOrig += tex2D( g_samSrcColor, Tex );

  return float4( ColorOrig, 1.0f );
}

technique PostProcess {
  pass p0 {
    VertexShader = null;
    PixelShader = compile ps_2_0 Combine();
    ZEnable = false;
  }
}