varying vec3 Reflect;
varying vec3 Refract;
varying float F;
varying vec3 water;

const vec3 deep = vec3(0.4, 0.45, 1.0);
const vec3 shallow = vec3(0.95, 0.95, 1.0);

void main() 
{
  vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;
  vec3 ecPosition3 = ecPosition.xyz / ecPosition.w;

  vec3 i = normalize(ecPosition).xyz;
  vec3 n = normalize(gl_NormalMatrix * gl_Normal);
 
  float cosTheta = dot(i, -n);
  F = 0.02 + 0.98 * pow((1.0 - cosTheta), 5.0);
  
  water = deep * cosTheta + shallow * (1.0 - cosTheta);

  Refract = refract(i, n, 0.4);
  Refract = vec3(gl_TextureMatrix[0] * vec4(Refract, 1.0));

  Reflect = reflect(i, n);
  Reflect = vec3(gl_TextureMatrix[0] * vec4(Reflect, 1.0));

  gl_Position = ftransform();
}