#version 120

varying vec3 normal;
varying vec3 vertex;

uniform sampler2D tex;

const vec4 AMBIENT_BLACK = vec4(0.0, 0.0, 0.0, 1.0);
const vec4 DEFAULT_BLACK = vec4(0.0, 0.0, 0.0, 0.0);


void main()
{
    // Normalize the normal. A varying variable CANNOT
    // be modified by a fragment shader. So a new variable
    // needs to be created.
    vec3 n = normalize(normal);
   
    vec4 ambient, diffuse, specular, color;

    // Initialize the contributions.
    ambient  = vec4(0.0);
    diffuse  = vec4(0.0);
    specular = vec4(0.0);
   
   	vec3 D = gl_LightSource[0].position.xyz - vertex;
    vec3 L = normalize(D);

    float dist = length(D);
  
	float attenuation = 1.0/(0.005*dist);

    float nDotL = dot(normal,L);

    if (nDotL > 0.0)
    {   
        vec3 E = normalize(-vertex);
        vec3 R = reflect(-L, normal);
       
        float pf = pow(max(dot(R,E), 0.0), gl_FrontMaterial.shininess);

        diffuse  += gl_LightSource[0].diffuse  * attenuation * nDotL;
        specular += gl_LightSource[0].specular * attenuation * pf;
    }
   
    ambient  += gl_LightSource[0].ambient * attenuation;
   
    color  = gl_FrontLightModelProduct.sceneColor  +
             (ambient  * gl_FrontMaterial.ambient) +
             (diffuse  * gl_FrontMaterial.diffuse) +
             (specular * gl_FrontMaterial.specular);
	
	//color *= texture2D(tex, vec2(gl_TexCoord[0]));	
	
    color = clamp(color, 0.0, 1.0);
    	
    gl_FragColor = color;
}