varying vec3 eye, ecPosition3, normal;


// orange
void PointLight(in int i,
				in vec3 eye,
				in vec3 ecPosition3,
				in vec3 normal,
				inout vec4 ambient,
				inout vec4 diffuse,
				inout vec4 specular)
{
	float nDotVP;
	float nDotHV;
	float pf;
	float attenuation;
	float d;
	vec3 VP;
	vec3 halfVector;
	
	VP = vec3(gl_LightSource[i].position) - ecPosition3;
	
	d = length(VP);
	
	VP = normalize(VP);
	
	attenuation = 1.0 / (gl_LightSource[i].constantAttenuation +
						 gl_LightSource[i].linearAttenuation * d +
						 gl_LightSource[i].quadraticAttenuation * d * d);
					 
	halfVector = normalize(VP + eye);
	
	nDotVP = max(0.0, dot(normal, VP));
	nDotHV = max(0.0, dot(normal, halfVector));
	
	if(nDotVP == 0.0)
		pf = 0.0;
	else
		pf = pow(nDotHV, gl_FrontMaterial.shininess);
	
	ambient += gl_LightSource[i].ambient * attenuation;
	diffuse += gl_LightSource[i].diffuse * nDotVP * attenuation;
	specular += gl_LightSource[i].specular * pf * attenuation;
}

void light(out vec4 color)
{
	vec4 ambient = vec4(0.0);
	vec4 diffuse = vec4(0.0);
	vec4 specular = vec4(0.0);
	
	PointLight(0, eye, ecPosition3, normal, ambient, diffuse, specular);
	
	color = gl_FrontLightModelProduct.sceneColor + ambient * gl_FrontMaterial.ambient + diffuse * gl_FrontMaterial.diffuse + specular * gl_FrontMaterial.specular;
}

void main()
{
	// lighting
	vec4 color = vec4(0.0);
	light(color);
	
	// (cube) texture mapping
	
	// volumetric light
	
	gl_FragColor = color;

}


