varying vec4 shadowTexCoord;

uniform sampler2D tex;

varying vec3 eyeVec;
varying vec3 normal;
varying vec3 lightDir;


void main (void)
{
	// vertex calculation
	gl_Position = ftransform();
	gl_FrontColor  = gl_Color;

	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);

	lightDir = vec3(gl_LightSource[0].position.xyz - vVertex);
	eyeVec = -vVertex;


	normal = gl_NormalMatrix * gl_Normal;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	// V = gl_Position.xyz;
	
	// shadow texture coordinates generation
	shadowTexCoord = gl_ModelViewMatrixInverse * gl_TextureMatrix[0] * gl_ModelViewMatrix * gl_Vertex;
}